#ifndef MARS_MGeomCamMagicEnhance
#define MARS_MGeomCamMagicEnhance

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MArrayD;
class MCerPhotEvt;

class MGeomCamMagicEnhance : public MTask
{
private:
    static const char *fgNameCerPhotEvtIn;
    static const char *fgNameCerPhotEvtOut;

    TString fNameCerPhotEvtIn;
    TString fNameCerPhotEvtOut;

    MCerPhotEvt *fEvtIn;
    MCerPhotEvt *fEvtOut;

    MArrayD Convert() const;

    Int_t PreProcess(MParList *p);
    Int_t Process();

    void CleanFreqSpace(MArrayD &re, MArrayD &im);

public:
    MGeomCamMagicEnhance(const char *name=0, const char *title=0);

    void SetNameCerPhotEvtIn(const char *n) { fNameCerPhotEvtIn = n; }
    void SetNameCerPhotEvtOut(const char *n) { fNameCerPhotEvtOut = n; }

    ClassDef(MGeomCamMagicEnhance, 0) //Task to convert MCerPhotEvt from MGeomCamMagic to MGeomCamMagicXT
};
    
#endif
