#ifndef MARS_MFSelBasic
#define MARS_MFSelBasic

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFSelBasic                                                           //
//                                                                         //
// Class to evaluate basic cuts                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MPointingPos;
class MGeomCam;
class MCerPhotEvt;
//class MPedPhotCam;
class MRawRunHeader;

class MFSelBasic : public MFilter
{
private:
    const MPointingPos  *fPointPos;       
    const MGeomCam      *fCam;      // Camera Geometry 
    const MCerPhotEvt   *fEvt;      // Cerenkov Photon Event 
    //    const MPedPhotCam   *fPed;      // Pedestal information
    const MRawRunHeader *fRawRun;

    Float_t     fMinPhotons;
    Float_t     fThetaMin;
    Float_t     fThetaMax;

    Float_t     fPhiMin;
    Float_t     fPhiMax;

    Int_t       fCut[7];

    Bool_t      fResult;

    Int_t Set(Int_t rc);

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

    Bool_t IsExpressionTrue() const { return fResult; }

    Bool_t SwTrigger();

public:
    MFSelBasic(const char *name=NULL, const char *title=NULL);

    void SetCuts(Float_t minphotons=0.0, 
                 Float_t thetamin=0.0, Float_t thetamax=90.0,
                 Float_t phimin=0.0,   Float_t phimax=360.0);

    ClassDef(MFSelBasic, 0)   // Class to evaluate basic cuts
};

#endif











