#ifndef MARS_MJCalibrateSignal
#define MARS_MJCalibrateSignal

#ifndef MARS_MJob
#include "MJob.h"
#endif

class TEnv;
class TList;
class MRunIter;
class MTask;
class MParList;
class MGeomCam;
class MSequence;
class MExtractor;
class MPedestalCam;
class MBadPixelsCam;

class MJCalibrateSignal : public MJob
{
private:

    MRunIter *fRuns;                    // Data files

    Bool_t fIsInterlaced;               // Distinguish interlaced from other calibration
    Bool_t fIsRelTimesUpdate;           // Choose to update relative times from interlaced
    Bool_t fIsHiLoCalibration;          // Choose to calibrate the high-gain vs. low-gains
    

    enum DataType_t
      {
        kIsUseRawData,
        kIsUseRootData,
        kIsUseMC
      };

    Byte_t    fDataFlag;      // Bit-field to store the data type

    Bool_t IsUseRawData()  const { return TESTBIT(fDataFlag,kIsUseRawData);  }
    Bool_t IsUseRootData() const { return TESTBIT(fDataFlag,kIsUseRootData); }
    Bool_t IsUseMC()       const { return TESTBIT(fDataFlag,kIsUseMC);       }

    void   SetUseRawData ( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseRawData)  : CLRBIT(fDataFlag,kIsUseRawData);  }
    void   SetUseRootData( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseRootData) : CLRBIT(fDataFlag,kIsUseRootData); }
    void   SetUseMC      ( const Bool_t b=kTRUE )  { b ? SETBIT(fDataFlag,kIsUseMC)       : CLRBIT(fDataFlag,kIsUseMC);       }

    Bool_t CheckEnvLocal();

    void   DisplayResult(MParList &plist);

    Bool_t WriteResult(TObjArray &cont);
    Bool_t ReadCalibration(TObjArray &o, MBadPixelsCam &bpix,
                           MExtractor* &ext1, MExtractor* &ext2, TString &geom) const;

public:

    MJCalibrateSignal(const char *name=NULL, const char *title=NULL);

    Bool_t ProcessFile(MPedestalCam &camab, MPedestalCam &cam1, MPedestalCam &cam2);

    void SetInterlaced     ( const Bool_t b=kTRUE )  { fIsInterlaced      = b; }
    void SetRelTimesUpdate ( const Bool_t b=kTRUE )  { fIsRelTimesUpdate  = b; }
    void SetHiLoCalibration( const Bool_t b=kTRUE )  { fIsHiLoCalibration = b; }

    void SetInput      ( MRunIter *iter       )  { fRuns = iter; }
    
    ClassDef(MJCalibrateSignal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
