#ifndef MARS_MSrcPosCalc
#define MARS_MSrcPosCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TVector2
#include <TVector2.h>
#endif

class MObservatory;
class MPointingPos;
class MSrcPosCam;
class MGeomCam;
class MTime;
class MVector3;

class MSrcPosCalc : public MTask
{
private:
    MObservatory *fObservatory;
    MPointingPos *fPointPos;
    MPointingPos *fSourcePos;
    MSrcPosCam   *fSrcPosCam;
    MGeomCam     *fGeom;
    MTime        *fTime;

    TVector2 CalcXYinCamera(const MVector3 &pos0, const MVector3 &pos) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MSrcPosCalc(const char *name=NULL, const char *title=NULL);

    ClassDef(MSrcPosCalc, 0) // Derotates the source position in the camera
};

#endif
