#ifndef MARS_MImageParDisp
#define MARS_MImageParDisp

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MImageParDisp : public MParContainer
{
private:

    Float_t fDisp;     // [deg] distance between the image center
                       //       and the estimated source position,
                       //       along the major axis of the image

public:

    MImageParDisp(const char *name=NULL, const char *title=NULL);

    void Reset();

    void SetDisp(Float_t disp)  { fDisp = disp; }
    Float_t GetDisp() const     { return fDisp; }

    void Print(Option_t *opt=NULL) const;

    ClassDef(MImageParDisp, 1) // Container to hold estimated distance to source position (Disp)
};

#endif
