/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationIntensityQECam                                               
//                                                               
// Storage container for intensity charge calibration results. 
// 
// Individual MCalibrationQECam's can be retrieved with: 
// - GetCam() yielding the current cam.
// - GetCam("name") yielding the current camera with name "name".
// - GetCam(i) yielding the i-th camera.
//
// See also: MCalibrationIntensityCam, MCalibrationQECam,
//           MCalibrationQEPix, MCalibrationChargeCalc
//           MHCalibrationChargePix, MHCalibrationChargeCam              
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationIntensityQECam.h"
#include "MCalibrationQECam.h"

#include <TOrdCollection.h>

ClassImp(MCalibrationIntensityQECam);

using namespace std;
// --------------------------------------------------------------------------
//
// Default constructor. 
//
MCalibrationIntensityQECam::MCalibrationIntensityQECam(const char *name, const char *title)
{

  fName  = name  ? name  : "MCalibrationIntensityQECam";
  fTitle = title ? title : "Results of the Intensity Calibration";
  
  InitSize(1);
}

// -------------------------------------------------------------------
//
// Add MCalibrationQECams in the ranges from - to. 
//
void MCalibrationIntensityQECam::Add(const UInt_t from, const UInt_t to)
{
  for (UInt_t i=from; i<to; i++)
    fCams->AddAt(new MCalibrationQECam,i);
}

// --------------------------------------------------------------------------
//
// Calls TObjArray::Expand() for fCams and initialze one MCalibrationQECam
// and copy the entries
// 
void MCalibrationIntensityQECam::InitSize(const UInt_t n)
{

  MCalibrationQECam *oldcam = NULL;

  if (n>1)
    oldcam = (MCalibrationQECam*)GetCam();

  MCalibrationIntensityCam::InitSize(n);
  
  MCalibrationQECam *newcam = (MCalibrationQECam*)GetCam();  
  
  if (oldcam)
    oldcam->Copy(*newcam);
}

