#ifndef MARS_MJCalibrateSignal
#define MARS_MJCalibrateSignal

#ifndef MARS_MJob
#include "MJob.h"
#endif

class TEnv;
class TList;

class MTask;
class MParList;
class MGeomCam;
class MSequence;
class MExtractor;
class MPedestalCam;
class MBadPixelsCam;

class MJCalibrateSignal : public MJob
{
private:

    Bool_t fIsDataCheck;
    Bool_t fIsInterlaced;               // Distinguish interlaced from other calibration
    Bool_t fIsRelTimesUpdate;           // Choose to update relative times from interlaced
    Bool_t fIsHiLoCalibration;          // Choose to calibrate the high-gain vs. low-gains
    
    Bool_t CheckEnvLocal();

    void   DisplayResult(MParList &plist);
    void   DrawTab(MParList &plist, const char *cont, const char *name, Option_t *opt);

    Bool_t WriteResult(TObjArray &cont);
    Bool_t ReadCalibration(TObjArray &o, MBadPixelsCam &bpix,
                           MExtractor* &ext1, MExtractor* &ext2, TString &geom) const;

    Bool_t IsDataCheck() const { return fIsDataCheck; }
    void SetDataCheck(Bool_t b) { fIsDataCheck = b; }

public:
    MJCalibrateSignal(const char *name=NULL, const char *title=NULL);

    Bool_t ProcessFile(MPedestalCam &camab, MPedestalCam &cam1, MPedestalCam &cam2);

    void SetInterlaced     ( const Bool_t b=kTRUE )  { fIsInterlaced      = b; }
    void SetRelTimesUpdate ( const Bool_t b=kTRUE )  { fIsRelTimesUpdate  = b; }
    void SetHiLoCalibration( const Bool_t b=kTRUE )  { fIsHiLoCalibration = b; }

    ClassDef(MJCalibrateSignal, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
