#include "MCerPhotEvt.h"

#include <math.h>
#include <fstream.h>

#include <TCanvas.h>
#include <TClonesArray.h>

#include "MLog.h"
#include "MGeomCam.h"
#include "MCamNeighbor.h"
#include "MCamDisplay.h"
#include "MHexagon.h"

ClassImp(MCerPhotEvt)

MCerPhotEvt::MCerPhotEvt(const char *name, const char *title ) : fType(0), fNbPixels(0)
{
  //   the default constructor 

  
  *fName  = name  ? name  : "MCerPhotEvt";
  *fTitle = name  ? name  : "(Number of Photon)-Event Information";
  
  fPixels = new TClonesArray ("MCerPhotPix", 577) ;

  //
  // FIXME: is this really necessary?
  //
  fPixels->Clear();
}

void MCerPhotEvt::Draw(Option_t* option) 
{
  //   FIXME!!!
  // 
  
  MCamDisplay *disp = new MCamDisplay(fType)  ; 
  
  disp->DrawPhotNum(this) ;
}

Int_t MCerPhotEvt::GetNbPixels() 
{
  return fNbPixels;
} 

void MCerPhotEvt::AddPixel(Int_t id, Float_t nph, Float_t err)
{
    //
    // add a new pixel to the list and increase the number
    // of valid pixels in the list by one
    //
    (*fPixels)[fNbPixels++] = new MCerPhotPix( id, nph, err);
}

void MCerPhotEvt::Clear(Option_t *)
{
    //
    // reset counter and delete netries in list.
    //
    fNbPixels = 0 ;
    fPixels->Clear() ;
}

void MCerPhotEvt::Print(Option_t *)
{
    const Int_t entries = fPixels->GetEntries();

    *fLog << "MCerPhotEvt::Print()" << endl
        << "Number of Pixels: " << fNbPixels
        << "(" << entries << ")"
        << endl ;

    for (Int_t il=0; il<entries; il++ )
        (*this)[il].Print();
}

void MCerPhotEvt::CleanLevel1()
{
    //
    //  This method looks for all pixels with an entry (photons)
    //  that is three times bigger than the noise of the pixel
    //

    const Int_t entries = fPixels->GetEntries();

    //
    // check the number of all pixels against the noise level and
    // set them to 'unused' state if necessary
    //
    for (Int_t il=0; il<entries; il++ )
    {
        MCerPhotPix &pix = (*this)[il];

        const Float_t entry = pix.GetNumPhotons();
        const Float_t noise = pix.GetErrorPhot();

        if (entry < 3 * noise )
            pix.SetPixelUnused();
    }
}

void MCerPhotEvt::CleanLevel2()
{
    //
    //  check if the  survived pixel have a neighbor, that also
    //  survived
    //

    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++)
    {
        //
        // get entry il from list
        //
        MCerPhotPix &pix = (*this)[il];

        //
        // check if pixel is in use, if not goto next pixel in list
        //
        if (!pix.IsPixelUsed())
            continue;

        //
        // get pixel id of this entry
        //
        const Int_t id = pix.GetPixId() ;

        //
        // count number of next neighbors of this pixel which
        // state is 'used'
        //
        Int_t itest = 0 ;
        for (Int_t in=0 ; in < 6; in++ )
        {
            const Int_t id2 = fNN.GetNN(id, in) ;

            if (id2 < 0)
                continue;

            if (IsPixelUsed(id2))
                itest++ ;
        }

        //
        // check if no next neighbor has the state 'used'
        // set this pixel to 'unused', too.
        //
        if (itest==0)
            pix.SetPixelUnused();
    }

    //
    // now we declare all pixels that survive as CorePixels
    //
    for (Int_t il=0; il<entries; il++)
    {
        MCerPhotPix &pix = (*this)[il];

        if (pix.IsPixelUsed())
            pix.SetCorePixel();
    }

} 

void MCerPhotEvt::CleanLevel3()
{
    //
    //   Look for the boundary pixels around the core pixels
    //   if a pixel has more than 2.5 sigma, and a core neigbor
    //   it is declared as used.
    //
    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++)
    {
        //
        // get pixel as entry il from list
        //
        MCerPhotPix &pix = (*this)[il];

        //
        // if pixel is a core pixel go to the next pixel
        //
        if (pix.IsCorePixel())
            continue;

        //
        // check the num of photons against the noise level
        //
        const Float_t entry = pix.GetNumPhotons();
        const Float_t noise = pix.GetErrorPhot();

        if (entry <= 2.5 * noise )
            continue;

        //
        // get pixel id of this entry
        //
        const Int_t id = pix.GetPixId();

        //
        // check if the pixel's next neighbor is a core pixel.
        // if it is a core pixel set pixel state to: used.
        //
        for (Int_t in=0; in<6 ; in++)
        {
            const Int_t id2 = fNN.GetNN(id, in);

            if (id2 <0)
                continue;

            if (!IsPixelCore(id2))
                continue;

            pix.SetPixelUsed();

            break ;
        }
    }
}


Bool_t MCerPhotEvt::IsPixelExisting(Int_t id)
{
    //
    // Checks if in the pixel list is an entry with pixel id
    //
    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++)
    {
        if (id == (*this)[il].GetPixId())
            return kTRUE ;
    }

    return kFALSE ;
} 

Bool_t MCerPhotEvt::IsPixelUsed(Int_t id)
{
    //
    //   Checks if in the pixel list is an entry with pixel id
    //
    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++ )
    {
        MCerPhotPix &pix = (*this)[il];

        if (id == pix.GetPixId() && pix.IsPixelUsed())
            return kTRUE ;
    }

    return kFALSE ;
} 

Bool_t MCerPhotEvt::IsPixelCore(Int_t id)
{
    //
    //   Checks if in the pixel list is an entry with pixel id
    //
    const Int_t entries = fPixels->GetEntries();

    for (Int_t il=0; il<entries; il++ )
    {
        MCerPhotPix &pix = (*this)[il];

        if ( id == pix.GetPixId() && pix.IsCorePixel())
            return kTRUE ;
    } 

    return kFALSE ;
} 

Float_t MCerPhotEvt::GetMinNumPhotons()
{
    //
    // get the minimum number of photons of all valid pixels in the list
    //
    if (fNbPixels <= 0)
        return -5. ;

    Float_t minval = (*this)[0].GetNumPhotons();

    Float_t testval;
    for (Int_t i=1 ; i<fNbPixels; i++ )
    {
        testval = (*this)[i].GetNumPhotons();

        if (testval < minval)
            minval = testval;
    }

    return minval;
}

Float_t MCerPhotEvt::GetMaxNumPhotons()
{
    //
    // get the maximum number of photons of all valid pixels in the list
    //
    if (fNbPixels <= 0)
        return 50.;

    Float_t maxval = (*this)[0].GetNumPhotons();

    Float_t testval;
    for (Int_t i=1; i<fNbPixels; i++)
    {
        testval = (*this)[i].GetNumPhotons();

        if (testval > maxval)
            maxval = testval;
    }
    return maxval;
}

