#include "MViewAdcSpectra.h" 

#include <iostream.h>

#include "MParList.h"
#include "MTaskList.h"
#include "MEvtLoop.h"

#include "MRawRunHeader.h"
#include "MRawEvtHeader.h"
#include "MRawEvtData.h"
#include "MRawCrateArray.h"
#include "MTime.h"

#include "MReadTree.h" 
#include "MDumpEvtHeader.h" 
#include "MFillAdcSpect.h" 
#include "MShowSpect.h" 
#include "MHistosAdc.h" 

MViewAdcSpectra::MViewAdcSpectra() 
{
  // default constructor  
} 

MViewAdcSpectra::~MViewAdcSpectra() 
{
    // default destructor
    delete fHistosAdc;
} 


// ================================================================================
Bool_t MViewAdcSpectra::AdcSpectra ( Char_t *inputfile, Char_t *treeName ) 
{
  //   This job reads in the FADC data from all events and fills
  //   the spectrum for each pmt pixel.
  //

  cout << "PedAdcSpectra:: Analyse the tree " << treeName 
       << "in the file  " << inputfile << endl ;
  
  // create a (empty) list of parameters which can be used by the tasks
  // and an (empty) list of tasks which should be executed
  // connect them in the required way. 
 
  //
  //   create the data containers for the raw data
  //
  MParList plist;
  
  MRawRunHeader runheader;
  plist.AddToList(&runheader);

  MRawEvtHeader evtheader;
  plist.AddToList(&evtheader);
  
  MRawEvtData evtdata;
  plist.AddToList(&evtdata);
  
  MRawCrateArray cratearray;
  plist.AddToList(&cratearray);
  
  MTime evttime("MTime");
  plist.AddToList(&evttime);

  fHistosAdc= new MHistosAdc;
  plist.AddToList( fHistosAdc ) ;

  //
  //    set up the tasks for this job
  //
  MTaskList tasks;
  plist.AddToList(&tasks);

  MReadTree readin ( inputfile, treeName ) ;
  tasks.AddToList( &readin ) ;

  //  MDumpEvtHeader *dumpheader = new MDumpEvtHeader() ; 
  //  tasks->AddToList( dumpheader ) ; 
 
  MFillAdcSpect fillspect;
  tasks.AddToList( &fillspect ) ;

  MShowSpect showspect( "MHistosAdc" ) ;
  tasks.AddToList( &showspect ) ;

  //    set up the loop for the processing 
  
  MEvtLoop magic;
  magic.SetParList(&plist);

  //    start the loop running 

  magic.Eventloop() ; 
  
  return kTRUE ;

} 
