#include <TSystem.h>

#include "MParList.h"
#include "MTaskList.h"
#include "MEvtLoop.h"

#include "MRawFileRead.h"
#include "MRawFileWrite.h"

#include "MLog.h"
#include "MTime.h"
#include "MRawEvtData.h"
#include "MRawRunHeader.h"
#include "MRawEvtHeader.h"
#include "MRawCrateArray.h"
#include "MInputStreamID.h"

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This is an easy implementation of the Merging process                    //
// (as compilable prog)                                                     //
//                                                                          //
// at the moment it reads a binary file ("rawtest.bin") which was written   //
// in the DAQ raw format.                                                   //
//                                                                          //
// The data are stored in root container objects (classes derived from      //
// TObject like MRawRunHeader)                                              //
//                                                                          //
// This containers are written to a root file ("rawtest.root")              //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

int main(const int argc, const char **argv)
{
    gLog << "==================================================" << endl ;
    gLog << "                   MERPP v0.1" << endl;
    gLog << "      MARS Merging and Preprocessing Program" << endl ;
    gLog << "            Compiled on <" << __DATE__ << ">" << endl ;
    gLog << "==================================================" << endl ;
    gLog << endl;

    //
    // check for the right usage of the program
    //
    if (argc<3 || argc>4)
    {
        gLog << "Sorry the usage is:" << endl;
        gLog << "   merpp inputfile outputfile [compression level]" << endl << endl;
        return -1;
    }

    //
    // This is to make argv[i] more readable insidethe code
    //
    const char *kNamein   = argv[1];
    const char *kNameout  = argv[2];
    const int   kComprlvl = argc==4 ? atoi(argv[3]) : 9;

    //
    //     initialize ROOT  (this is obligatory here)
    //
    TROOT simple("Merpp","Mars - Merging and Preprocessing Program");

    //
    // check whether the given files are OK.
    //
    if (gSystem->AccessPathName(kNamein, kFileExists))
    {
        gLog << "Sorry, the file '" << kNamein << "' doesn't exist." << endl;
        return -1;
    }

    if (!gSystem->AccessPathName(kNameout, kFileExists))
        gLog << "Warning: The file '" << kNameout << "' exists." << endl;
    else
        if (!gSystem->AccessPathName(kNameout, kWritePermission))
        {
            gLog << "Sorry, you don't have write permission for '" << kNameout << "'." << endl;
            return -1;
        }

    //
    // create a (empty) list of parameters which can be used by the tasks
    // and an (empty) list of tasks which should be executed
    //
    MParList plist;

    MTaskList tasks;
    plist.AddToList(&tasks);

    MRawRunHeader runheader;
    plist.AddToList(&runheader);

    MRawEvtHeader evtheader;
    plist.AddToList(&evtheader);

    MRawEvtData evtdata;
    plist.AddToList(&evtdata);

    MRawCrateArray cratearray;
    plist.AddToList(&cratearray);

    MTime evttime("MRawEvtTime");
    plist.AddToList(&evttime);

    //
    // create the tasks which should be executed and add them to the list
    // in the case you don't need parameter containers, all of them can
    // be created by MRawFileRead::PreProcess
    //
    MRawFileRead  reader(kNamein);
    MRawFileWrite writer(kNameout, "RECREATE", "Title", kComprlvl);
    tasks.AddToList(&reader);
    tasks.AddToList(&writer);

    //
    // create the looping object and thell it about the parameters to use
    // and the tasks to execute
    //

    MEvtLoop magic;

    magic.SetParList(&plist);

    //
    // Start the eventloop which reads the raw file (MRawFileRead) and
    // write all the information into a root file (MRawFileWrite)
    //
    // between reading and writing we can do, transformations, checks, etc.
    // (I'm think of a task like MRawDataCheck)
    //
    magic.Eventloop();

    return 0;
}


