#ifndef MARS_MHCollectionArea
#define MARS_MHCollectionArea

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MMcEvt;
class MParameterD;

class MHCollectionArea : public MH
{
private:
    MMcEvt *fMcEvt;
    MParameterD *fEnergy;

    TH2D fHistSel;
    TH2D fHistAll;

    TH1D fHEnergy;

    Float_t fMcAreaRadius; // [m] Radius of circle within which the cores of Corsika events have been uniformly distributed.

    UInt_t fTotalNumSimulatedShowers;
    UInt_t fCorsikaVersion;
    Bool_t fAllEvtsTriggered;
    Bool_t fIsExtern;

    void Calc(TH2D &hsel, TH2D &hall);

public:
    MHCollectionArea(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);
    Bool_t ReInit(MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t weight=1);

    void Draw(Option_t *option="");
    void Paint(Option_t *option="");

    void CalcEfficiency();

    void SetHistAll(const TH2D &h) { h.Copy(fHistAll); fIsExtern=kTRUE; }

    TH2D &GetHistAll()             { return fHistAll; }
    const TH2D &GetHistAll() const { return fHistAll; }

/*
    void DrawAll(Option_t *option="");
    void DrawSel(Option_t *option="");

    const TH1D *GetHist()       { return fHistCol; }
    const TH1D *GetHist() const { return fHistCol; }



    void CalcEfficiency();
    void CalcEfficiency2();

    void Calc(const MHMcEnergyImpact &mcsel, const MHMcEnergyImpact &mcall);
    void Calc(const MHMcEfficiency &heff);
  */
    void SetMcAreaRadius(Float_t x) { fMcAreaRadius = x; }

    ClassDef(MHCollectionArea, 1)  // Data Container to calculate Collection Area
};

#endif
