#ifndef MARS_MMuonCalibParCalc
#define MARS_MMuonCalibParCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMuonSearchPar;
class MMuonCalibPar;
class MSrcPosCam;
class MGeomCam;
class MSignalCam;
class MMuonSetup;

class MMuonCalibParCalc : public MTask
{
private:
    MGeomCam       *fGeomCam;
    MSignalCam     *fSignalCam;
    MMuonCalibPar  *fMuonCalibPar;  
    MMuonSearchPar *fMuonSearchPar; 
    MMuonSetup     *fMuonSetup;

    Bool_t fEnableImpactCalc; // If true, the impact calculation will be done, which consumes a lot of time.

    Int_t PreProcess(MParList *plist);
    Int_t Process();

public:
    MMuonCalibParCalc(const char *name=NULL, const char *title=NULL);

    void EnableImpactCalc()              { fEnableImpactCalc = kTRUE; }

    void FillHist();
    void CalcPhi();
    void CalcImpact(Int_t effbinnum, Float_t startfitval, Float_t endfitval);
    Float_t CalcWidth();
    Int_t   Calc();

    ClassDef(MMuonCalibParCalc, 0) // task to calculate muon parameters
};

#endif
