#ifndef MREADTREE_H
#define MREADTREE_H

#ifndef MTASK_H
#include "MTask.h"
#endif

class TFile;
class TChain;

class MReadTree : public MTask
{
private:
    TFile  *fFile;       // Pointer to file
    TChain *fChain;      // Pointer to tree

    UInt_t  fNumEntry;   // Number of actual entry
    UInt_t  fNumEntries; // Number of Events in Tree

public:
    MReadTree(const char *treename, const char *filename=NULL, const char *name=NULL, const char *title=NULL);
    ~MReadTree();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void AddFile(const char *fname);

    Bool_t GetEvent() ; 

    Bool_t DecEventNum(UInt_t dec=1); // decrease number of event (position in tree)
    Bool_t IncEventNum(UInt_t inc=1); // increase number of event (position in tree)
    Bool_t SetEventNum(UInt_t nr);    // set number of event (position in tree)

    UInt_t GetEventNum() const { return fNumEntry;   }
    UInt_t GetEntries() const  { return fNumEntries; }

    ClassDef(MReadTree, 0)	// Reads one tree
};

#endif
