#ifndef MARS_MEnergyEstimate
#define MARS_MEnergyEstimate

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MData;
class MParameterD;

class MEnergyEstimate : public MTask
{
private:
    MData       *fData;    //->
    MParameterD *fEnergy;  //!

    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print=kFALSE);

public:
    MEnergyEstimate(const char *name=NULL, const char *title=NULL);
    ~MEnergyEstimate();

    Bool_t SetRule(const char *rule);

    Int_t PreProcess(MParList *plist);
    Int_t Process();

    void SetVariables(const TArrayD &);

    void Print(Option_t *o="") const; //*MENU*

    ClassDef(MEnergyEstimate, 1) // Task to estimate the energy by a rule
};

#endif

