#ifndef MARS_MHadAlphaCut
#define MARS_MHadAlphaCut

#ifndef MARS_MH
#include "MH.h"
#endif

class TH2F;

class MHadAlphaCut : public MH
{
 private:

    TH2F*  fHistHadCut;
    TH2F*  fHistAlphaCut;
  

 public:
    
    MHadAlphaCut(const char* name=NULL, const char* title=NULL);

    Float_t GetAlphaCut(Float_t energy, Float_t zd);
    Float_t GetHadCut(Float_t energy, Float_t zd);
    
    void Print(Option_t *o="") const;
    void Draw(Option_t *o="");
    
    TH2F* GetHistHadCut() const   { return fHistHadCut; }
    TH2F* GetHistAlphaCut() const { return fHistAlphaCut; }


    ClassDef(MHadAlphaCut, 1)	// Container for Hadronness and Alpha cut for each estimated energy and theta bin
};

#endif
