void optimwobble()
{
    MJOptimizeCuts opt("MHThetaSq");
    opt.SetDebug(2);
    opt.SetOptimizer(MJOptimize::kSimplex);

    // ------------------- Xi -----------------------
    opt.SetParameter(0, 0.6);
    opt.FixParameter(6, 0.137);

    // --------------- Theta Sq ---------------------
    opt.SetParameter(1, 0.23);

    // ----------------- Area -----------------------
    opt.SetParameter(2, 0.25);
    opt.SetParameter(3, 5.21);
    opt.SetParameter(4, 0.11);

    // ----------------- M3L ------------------------
    opt.SetParameter(5, -0.089);

    // ----------------- Fit ------------------------

    MAlphaFitter fit;
    fit.SetScaleMode(MAlphaFitter::kNone);
    fit.SetSignalFunction(MAlphaFitter::kThetaSq);
    fit.SetMinimizationStrategy(MAlphaFitter::kSignificanceLogExcess);

    // ----------------- Cuts -----------------------

    MFMagicCuts cuts;
    cuts.SetAlphaCut(MFMagicCuts::kWobble);

    /* You can also try (switch on scaling):

     fit.SetScaleMode(MAlphaFitter::kBackground);
     fit.SetBackgroundFitMin(0.12);
     fit.SetBackgroundFitMax(0.5);

     cuts.SetThetaCut(MFMagicCuts::kOff);
     */

    // -----------------------------------------------------------

    MStatusDisplay *d = new MStatusDisplay;
    opt.SetDisplay(d);

    opt.RunOnOff("wobblelza-abs.root", &cuts, &fit);
}
