#ifndef MARS_MJTrainRanForest
#define MARS_MJTrainRanForest

#ifndef MARS_MJob
#include "MJob.h"
#endif

class MFilter;

class MJTrainRanForest : public MJob
{
protected:
    Bool_t fDebug;

    TList fRules;

    TList fPreCuts;
    TList fTrainCuts;
    TList fTestCuts;

    Bool_t WriteDisplay(const char *fname) const;

    void AddCut(TList &l, const char *rule);
    void AddCut(TList &l, MFilter *f);

public:
    MJTrainRanForest() : fDebug(kFALSE) { }

    void SetDebug(Bool_t b=kTRUE) { fDebug = b; }

    void AddPreCut(const char *rule)   { AddCut(fPreCuts, rule); }
    void AddPreCut(MFilter *f)         { AddCut(fPreCuts, f); }

    void AddTrainCut(const char *rule) { AddCut(fTrainCuts, rule); }
    void AddTrainCut(MFilter *f)       { AddCut(fTrainCuts, f); }

    void AddTestCut(const char *rule)  { AddCut(fTestCuts, rule); }
    void AddTestCut(MFilter *f)        { AddCut(fTestCuts, f); }

    Int_t AddParameter(const char *rule);

    ClassDef(MJTrainRanForest, 0)//Base class for Random Forest training classes
};

#endif
