#ifndef MARS_MJTrainSeparation
#define MARS_MJTrainSeparation

#ifndef MARS_MJTrainRanForest
#include "MJTrainRanForest.h"
#endif

#ifndef MARS_MDataSet
#include "MDataSet.h"
#endif

class MH3;

class MJTrainSeparation : public MJTrainRanForest
{
private:
    MDataSet fDataSetTest;
    MDataSet fDataSetTrain;

    UInt_t fNumTrainOn;
    UInt_t fNumTrainOff;

    UInt_t fNumTestOn;
    UInt_t fNumTestOff;

    void DisplayResult(MH3 &h31, MH3 &h32);

public:
    MJTrainSeparation() :
        fNumTrainOn((UInt_t)-1), fNumTrainOff((UInt_t)-1), fNumTestOn((UInt_t)-1), fNumTestOff((UInt_t)-1)
    { }

    void SetDataSetTrain(const MDataSet &ds, UInt_t non=(UInt_t)-1, UInt_t noff=(UInt_t)-1)
    {
        ds.Copy(fDataSetTrain);
        fNumTrainOn = non;
        fNumTrainOff = noff;
    }
    void SetDataSetTest(const MDataSet &ds, UInt_t non=(UInt_t)-1, UInt_t noff=(UInt_t)-1)
    {
        ds.Copy(fDataSetTest);
        fNumTestOn = non;
        fNumTestOff = noff;
    }

    Bool_t Train(const char *out);

    ClassDef(MJTrainSeparation, 0)//Class to train Random Forest gamma-/background-separation
};

#endif
