/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz 11/2005 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2005
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MJTrainRanForest
//
// Base class for classes training a random forest
//
/////////////////////////////////////////////////////////////////////////////
#include "MJTrainRanForest.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MStatusDisplay.h"

#include "MF.h"

ClassImp(MJTrainRanForest);

using namespace std;

//------------------------------------------------------------------------
//
// Add a cut which is used to fill the matrix, eg "MMcEvt.fOartId<1.5"
// (The rule is applied, nit inverted: The matrix is filled with
// the events fullfilling the condition)
//
void MJTrainRanForest::AddCut(TList &l, const char *rule)
{
    MFilter *f = new MF(rule);
    f->SetBit(kCanDelete);
    AddCut(l, f);
}

//------------------------------------------------------------------------
//
// Add a cut which is used to fill the matrix. If kCanDelete is set
// MJOptimize takes the ownership.
//
void MJTrainRanForest::AddCut(TList &l, MFilter *f)
{
    l.Add(f);
}

//------------------------------------------------------------------------
//
// Add a parameter used in your filters (see AddFilter) The parameter
// index is returned,
//
//   Int_t idx = AddParameter("log10(MHillas.fSize)");
//
// The indices area starting with 0 always.
//
Int_t MJTrainRanForest::AddParameter(const char *rule)
{
    fRules.Add(new TNamed(rule, ""));
    return fRules.GetSize()-1;
}

Bool_t MJTrainRanForest::WriteDisplay(const char *fname) const
{
    TFile file(fname, "UPDATE");
    if (!file.IsOpen())
    {
        *fLog << err << "ERROR - Couldn't open file " << fname << " for writing." << endl;
        return kFALSE;
    }

    *fLog << inf << "Wrinting to " << fname << ":" << endl;
    *fLog << " - MStatusDisplay..." << flush;
    if (fDisplay && fDisplay->Write()<=0)
    {
        *fLog << err << "Unable to write MStatusDisplay to " << fname << endl;
        return kFALSE;
    }
    *fLog << inf << "ok." << endl;

    return kTRUE;
}
