/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Abelardo Moralejo, 11/2003 <mailto:moralejo@pd.infn.it>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  MStereoCalc
//
//  This is a task to calculate some shower parameters from the images of
//  two telescopes in stereo mode. 
//
//  Input Containers:
//   MGeomCam
//   MHillas
//   MMcEvt
//
//  Output Containers:
//   MStereoPar
//
/////////////////////////////////////////////////////////////////////////////
#include "MStereoCalc.h"

#include "MParList.h"

#include "MHillas.h"
#include "MMcEvt.hxx"
#include "MStereoPar.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MStereoCalc);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor.
//
MStereoCalc::MStereoCalc(const char *name, const char *title)
    : fStereoParName("MStereoPar")
{
    fName  = name  ? name  : "MStereoCalc";
    fTitle = title ? title : "Calculate shower parameters in stereo mode";

}

// --------------------------------------------------------------------------
//
// Check for MMcEvt and MHillas containers.
// Try to find the Geometry conatiner.
// Try to find (and maybe create) the container MStereoPar.
//
Int_t MStereoCalc::PreProcess(MParList *pList)
{
    // necessary

    fmcevt1 = (MMcEvt*)pList->FindObject(AddSerialNumber("MMcEvt",fCT1id));
    if (!fmcevt1)
    {
        *fLog << err << AddSerialNumber("MMcEvt",fCT1id) << " not found... aborting." << endl;
        return kFALSE;
    }

    // necessary
    fmcevt2 = (MMcEvt*)pList->FindObject(AddSerialNumber("MMcEvt",fCT2id));
    if (!fmcevt2)
    {
      *fLog << err << AddSerialNumber("MMcEvt",fCT2id) << " not found... aborting." << endl;
        return kFALSE;
    }

    // necessary
    TString geomname = "MGeomCam;";
    geomname += fCT1id;
    fGeomCam1 = (MGeomCam*)pList->FindObject(geomname);
    if (!fGeomCam1)
    {
        *fLog << err << geomname << " (Camera Geometry) missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    // necessary
    geomname = "MGeomCam;";
    geomname += fCT2id;
    fGeomCam2 = (MGeomCam*)pList->FindObject(geomname);
    if (!fGeomCam2)
    {
        *fLog << err << geomname << " (Camera Geometry) missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    // necessary
    TString hillasname = "MHillas;";
    hillasname += fCT1id;
    fHillas1 = (MHillas*)pList->FindObject(hillasname);
    if (!fHillas1)
    {
        *fLog << err << hillasname << " missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    // necessary
    hillasname = "MHillas;";
    hillasname += fCT2id;
    fHillas2 = (MHillas*)pList->FindObject(hillasname);
    if (!fHillas2)
    {
        *fLog << err << hillasname << " missing in Parameter List... aborting." << endl;
        return kFALSE;
    }

    fStereoPar = (MStereoPar*)pList->FindCreateObj("MStereoPar");
    if (!fStereoPar)
    {
	*fLog << err << "Could not create MStereoPar... aborting" << endl;
	return kFALSE;
    }

    return kTRUE;
}

// --------------------------------------------------------------------------
//
// Call the Calc procedure of the MStereoPar object, where the 
// calculations combining the data from the two telescopes are performed.
//
Int_t MStereoCalc::Process()
{
    fStereoPar->Calc(*fHillas1, *fmcevt1, *fGeomCam1, fCT1x, fCT1y, *fHillas2, *fmcevt2, *fGeomCam2, fCT2x, fCT2y);

    return kTRUE;
}

// --------------------------------------------------------------------------
//
// Does nothing at the moment.
//
Int_t MStereoCalc::PostProcess()
{
    return kTRUE;
}
