#ifndef MARS_MStereoCalc
#define MARS_MStereoCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MStereoCalc                                                             //
//                                                                         //
// Task to calculate some shower parameters in stereo mode                 //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif
#ifndef ROOT_TArrayL
#include <TArrayL.h>
#endif

class MGeomCam;
class MHillas;
class MMcEvt;
class MStereoPar;

class MStereoCalc : public MTask
{
    const MGeomCam    *fGeomCam1;    //! Camera Geometry CT1
    const MHillas     *fHillas1;     //! input
    const MMcEvt      *fmcevt1;      //! input

    const MGeomCam    *fGeomCam2;    //! Camera Geometry CT2
    const MHillas     *fHillas2;     //! input
    const MMcEvt      *fmcevt2;      //! input

    Int_t fCT1id;   //! 
    Int_t fCT2id;   //! Identifiers of the two analyzed telescopes.

    Float_t fCT1x;   //!
    Float_t fCT1y;   //! Position of first telescope
    Float_t fCT2x;   //!
    Float_t fCT2y;   //! Position of second telescope

    MStereoPar   *fStereoPar;     //! output container to store result
    TString       fStereoParName; // name of the 'MStereoPar' container

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();


public:

    MStereoCalc(const char *name=NULL, const char *title=NULL);

    void SetNameStereoPar(const char *name) { fStereoParName = name; }

    void SetCTids(Int_t i, Int_t j) { fCT1id = i; fCT2id = j; }
    void SetCT1coor(Float_t x, Float_t y) { fCT1x = x; fCT1y = y; } // in m
    void SetCT2coor(Float_t x, Float_t y) { fCT2x = x; fCT2y = y; } // in m

    ClassDef(MStereoCalc, 0) // Task to calculate some shower parameters in stereo mode
};

#endif


