#ifndef MARS_MHSectorVsTime
#define MARS_MHSectorVsTime

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MHCamera
#include "MHCamera.h"
#endif

class MHCamera;
class MCamEvent;
class MGeomCam;

class MRawEvtHeader;
class MTime;
class TGraph;

class MHSectorVsTime : public MH
{
private:
    static const TString gsDefName;
    static const TString gsDefTitle;

private:
    TGraph *fGraph;

    MCamEvent *fEvt;        //! the current event
    MGeomCam  *fCam;        //! the camera geometry

    MRawEvtHeader *fHeader; //!
    MTime         *fTime;   //!

    MHCamera fHCamera;      //!

    Double_t fMin;          //! Calculation of minimum
    Double_t fMax;          //! Calculation of maximum

    Double_t fMinimum;      // User defined minimum
    Double_t fMaximum;      // User defined maximum

    TString fNameEvt;
    TString fNameTime;

    Int_t fType;
    Int_t fTypeErr;

    TArrayI fSectors;
    TArrayI fAreaIndex;

    // MH
    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

public:
    MHSectorVsTime(const char *name=NULL, const char *title=NULL);
    ~MHSectorVsTime();

    // Setter
    void SetNameEvt(const TString name)  { fNameEvt = name; }
    void SetNameTime(const TString name) { fNameTime = name; }
    void SetType(Int_t type, Int_t e=-1) { fType = type; fTypeErr=e; }
    void SetSectors(const TArrayI &s)    { fSectors=s; }
    void SetAreaIndex(const TArrayI &a)  { fAreaIndex=a; }

    void SetMinimum(Double_t min=-1111) { fMinimum = min; }
    void SetMaximum(Double_t max=-1111) { fMaximum = max; }

    // Getter
    TH1 *GetHistByName(const TString name="") const;
    TGraph *GetGraph() { return fGraph; }

    // TObject
    void SetName(const char *name);
    void SetTitle(const char *title);

    void Draw(Option_t *o=NULL);
    void Paint(Option_t *o=NULL);

    ClassDef(MHSectorVsTime, 2) // Histogram to sum camera events
};

#endif
