#ifndef MARS_MExtractedSignalPix
#define MARS_MExtractedSignalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MExtractedSignalPix : public MParContainer
{
private:

  Float_t fExtractedSignalHiGain;      // mean value of the extracted signal
  Float_t fExtractedSignalHiGainError; // error of the mean value of the extracted signal
  Float_t fExtractedSignalLoGain;      // mean value of the extracted signal
  Float_t fExtractedSignalLoGainError; // error of the mean value of the extracted signal

  Float_t fChisquare;                  // Chi-square of a possible fit the pulse
  
  Bool_t fLoGainUsed;
  Byte_t fNumHiGainSaturated;
  Byte_t fNumLoGainSaturated;

public:
  MExtractedSignalPix(const char* name=NULL, const char* title=NULL);

  void Clear(Option_t *o="");
  void Print(Option_t *o="") const;

  // Setter
  void SetExtractedSignal( Float_t sig, Float_t sigerr);
  void SetExtractedSignal( Float_t sighi, Float_t sighierr,Float_t siglo, Float_t sigloerr);
  void SetGainSaturation ( Bool_t sat, Byte_t higain, Byte_t logain);
  void SetChisquare      ( Float_t chi2 )   { fChisquare = chi2; }
    
  // Getter
  Float_t GetExtractedSignalHiGain()      const { return fExtractedSignalHiGain;       }
  Float_t GetExtractedSignalHiGainError() const { return fExtractedSignalHiGainError;  }

  Float_t GetExtractedSignalLoGain()      const { return fExtractedSignalLoGain;       }
  Float_t GetExtractedSignalLoGainError() const { return fExtractedSignalLoGainError;  }

  Byte_t GetNumHiGainSaturated()          const { return fNumHiGainSaturated;          }
  Byte_t GetNumLoGainSaturated()          const { return fNumLoGainSaturated;          }

  Float_t GetChisquare()                  const { return fChisquare;                   }
    
  Bool_t IsLoGainUsed()                   const { return fLoGainUsed;                  }
  Bool_t IsValid()                        const;   

  ClassDef(MExtractedSignalPix, 2) // Storage Container for Extracted Signal information of one pixel
};

#endif
