#ifndef MGDISPLAYADC_H
#define MGDISPLAYADC_H

#ifndef ROOT_TFrame
#include <TGFrame.h>    // TGTransientFrame
#endif
#ifndef ROOT_TGListBox
#include <TGListBox.h>  // TGListBox
#endif
#ifndef ROOT_TGSlider
#include <TGSlider.h>  // TGVSlider
#endif

#ifndef MHFADCCAM_H
#include "MHFadcCam.h"
#endif

class TGTextButton;
class TRootEmbeddedCanvas;
class TCanvas;
class TGRadioButton;

class MGDisplayAdc : public TGTransientFrame {
    private:
	
	MHFadcCam *fHists;		// Pointer to Container with the histograms
	
	// Create a main frame with a number of different buttons.
	//   
	TGCompositeFrame  *fFrameTop ;   // top part of the main window
	TGCompositeFrame  *fFrameLow ;   // low part of the main window
  
	TGVerticalFrame   *fFT1, *fFT2, *fFT3 ;
	
	TGListBox         *fHistoList ;
	TGTextButton      *fButtonPrev, *fButtonNext , *fButtonReset ;
	
	TRootEmbeddedCanvas  *fECanv , *fECanvLow;

	TGTextButton   *fButtonSave, *fButtonPrint, *fButtonPrintAll, *fButtonClose ; 
	
	TCanvas            *fCanv ;	
	
	
	//for sliders
	
	TGVSlider       *fVslider1;
	
        void  DrawHi(Int_t i)       { fHists->DrawHi(i); }
        void  DrawLo(Int_t i)       { fHists->DrawLo(i); }
        void  DrawSelectedHi()      { DrawHi( GetSelected()-1) ; }
        void  DrawSelectedLo()      { DrawLo( GetSelected()-1) ; }
        Int_t GetSelected()         { return fHistoList->GetSelected(); }
        void  SelectSelected()      { fHistoList->Select(GetSelected()-1, kTRUE); }
        void  SetSelectedTopEntry() { fHistoList->SetTopEntry(GetSelected()); }
        void  SetSelectedPos()      { fVslider1->SetPosition( GetSelected()-1); }
  
    public:
	
	//for radio buttons

	TGRadioButton *fRadio[3];

	
        Int_t    fHistoType;
        Bool_t    fHistoLock; 
	//
			
	
	TGPicture *fPicture;  
	TCanvas *fCanvas;
	
	MGDisplayAdc(MHFadcCam *fHists ,
		     const TGWindow *p, const TGWindow *main, 
		     UInt_t w, UInt_t h, 
		     UInt_t options = kMainFrame | kVerticalFrame ) ;
	
	~MGDisplayAdc(); 
  
	void  CloseWindow()  ;
       
	
	Bool_t BuildHistoList(Int_t type=1) ;
	
	Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
  
} ; 

#endif


