#ifndef MARS_MJob
#define MARS_MJob

#ifndef MARS_MSequence
#include "MSequence.h"
#endif

class MEnv;
class MEvtLoop;

class MJob : public MParContainer
{
private:
    enum { kIsOwner = BIT(14) };

    void FixPath(TString &path) const;
    void ClearEnv();

    const MEnv *fEnv;         // Resource file
    TString     fEnvPrefix;   // Prefix for resources
    Int_t       fEnvDebug;    // Debug setup of resources

protected:
    TString   fPathOut;       // Directory to write output file to (eg. calib*.root)
    TString   fPathIn;        // Directory to read output from (eg. calib*.root)
    TString   fPathData;      // Directory to read  data files from (2004*.root)

    Bool_t    fOverwrite;     // Allow overwriting output files
    Int_t     fMaxEvents;     // Maximum number of events

    MSequence fSequence;      // Sequence

    const TEnv *GetEnv() const;
    const MEnv *GetMEnv() const { return fEnv; }
    const TString &GetEnvPrefix() const { return fEnvPrefix; }
    Int_t GetEnvDebug() const { return fEnvDebug; }

    Int_t       GetEnv(const char *name, Int_t dflt) const;
    Double_t    GetEnv(const char *name, Double_t dflt) const;
    const char *GetEnv(const char *name, const char *dflt) const;
    Bool_t      HasEnv(const char *name) const;

    Bool_t SetupEnv(MEvtLoop &loop) const;
    Bool_t CheckEnv();
    Bool_t CheckEnv(MParContainer &c) const;
    void PrintUntouchedEnv() const;
    virtual Bool_t CheckEnvLocal() { return kTRUE; }

    Bool_t WriteContainer(TCollection &list) const;
    Bool_t ReadContainer(TCollection &list) const;
    Bool_t WriteContainer(TCollection &cont, const char *name, const char *option="RECREATE", const int compr=2) const;

public:
    MJob(const char *name=NULL, const char *title=NULL);
    ~MJob();

    // Setter
    void   SetPathOut(const char *path=".");
    void   SetPathIn(const char *path=".");
    void   SetPathData(const char *path=".");

    void   SetOverwrite(Bool_t b=kTRUE) { fOverwrite=b; }
    Bool_t SetEnv(const char *env, const char *prefix=0);
    void   SetEnv(MEnv *env, const char *prefix=0);
    void   SetEnvDebug(Int_t d=2) { fEnvDebug=d; }

    void   SetMaxEvents(Int_t max) { fMaxEvents = max; }
    void   SetSequence(const MSequence &seq) { fSequence = seq; }

    // Getter
    TString GetPathOut() const  { return fPathOut; }
    TString GetPathIn() const   { return fPathIn; }
    TString GetPathData() const { return fPathData; }

    // Others
    MStatusDisplay *GetDisplay() { return fDisplay; }

    static TString ExpandPath(TString fname);
    static void SortArray(TArrayI &arr);

    ClassDef(MJob, 0) // Bas class for Jobs
};

#endif
