<?php
{
    function CreateQuery($_GET, $alias, $checkwhere)
    {
        $query0 = "SELECT fSequenceFirst as 'Sequence#' ";

        foreach ($_GET as $key => $element)
            if ($_GET[$key]=="On")
                if (empty($checkwhere[$key]) || $checkwhere[$key]==0)
                    $query0 .= ", " . $key . " as '" . $alias[$key] . "' ";

        $query0 .= " FROM Star ";

        if (strpos($query0, " WHERE ")==FALSE)
            $query0 .= " WHERE ";
        else
            $query0 .= " AND ";

        $query0 .= "fSequenceFirst BETWEEN " . $_GET["fRunMin"] . " AND " . $_GET["fRunMax"] . " ";

        if (!empty($_GET["fSortBy"]))
        {
            $query0 .= " ORDER BY " . substr($_GET["fSortBy"], 0, -1) . " ";
            if (substr($_GET["fSortBy"], -1)=="-")
                $query0 .= "DESC";
        }

        if (empty($_GET["fNumStart"]))
            $_GET["fNumStart"]=0;

        if (empty($_GET["fSendTxt"]))
            $query0 .= " LIMIT " . $_GET["fNumStart"] . ", " . $_GET["fNumResults"];

        return $query0;
    }

    function InitGet($_GET)
    {
        // Find out whether it is the first call to the php script
        $first = empty($_GET["fRunMin"]) && empty($_GET["fRunMax"]);

        if (empty($_GET["fNumResults"]))
            $_GET["fNumResults"]="20";

        if (empty($_GET["fLastUpdate"]))
            $_GET["fLastUpdate"]="Off";

        if (empty($_GET["fMeanNumberIslands"]))
            $_GET["fMeanNumberIslands"]=$first?"On":"";

        if (empty($_GET["fPSF"]))
            $_GET["fPSF"]=$first?"On":"";

        if (empty($_GET["fRatio"]))
            $_GET["fRatio"]=$first?"On":"";

        if (empty($_GET["fMuonNumber"]))
            $_GET["fMuonNumber"]=$first?"On":"";

        if (empty($_GET["fEffOnTime"]))
            $_GET["fEffOnTime"]=$first?"On":"";

        if (empty($_GET["fMuonRate"]))
            $_GET["fMuonRate"]=$first?"On":"";

        if (empty($_GET["fInhomogeneity"]))
            $_GET["fInhomogeneity"]=$first?"On":"";

        if (empty($_GET["fDataRate"]))
            $_GET["fDataRate"]=$first?"On":"";

        if (empty($_GET["fMaxHumidity"]))
            $_GET["fMaxHumidity"]=$first?"On":"";

    }

    function PrintForm($_GET, $host, $user, $pw, $db)
    {
        printf("<center>\n");
        printf("<form action=\"querystar.php\" METHOD=\"GET\">\n");
        printf(" <table>\n");
        printf("  <tr>\n");

        CheckBox("fMeanNumberIslands",  "MeanNumIslands");
        CheckBox("fPSF",                "PSF");
        CheckBox("fRatio",              "Ratio");

        printf("  </tr><tr>\n");

        CheckBox("fMuonRate",           "MuonRate");
        CheckBox("fMuonNumber",         "MuonNumber");
        CheckBox("fEffOnTime",          "EffOnTime");

        printf("  </tr><tr>\n");

        CheckBox("fMaxHumidity",        "MaxHumidity");
        CheckBox("fDataRate",           "CleanedEvtRate");
        CheckBox("fInhomogeneity",      "Inhomogeneity");

        printf("  </tr>\n");
        printf(" </table>\n");
        printf(" <p>\n");

        if (empty($_GET["fRunMin"]))
            $min = GetMin("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $min = $_GET["fRunMin"];

        if (empty($_GET["fRunMax"]))
            $max = GetMax("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $max = $_GET["fRunMax"];


        printf("Sequences&nbsp;from&nbsp;<input name=\"fRunMin\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">\n", $min);
        printf("to&nbsp;<input name=\"fRunMax\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">&nbsp;&nbsp;&nbsp;\n", $max);

        printf(" <P>\n");

        printf(" Results:\n");
        printf(" <select name=\"fNumResults\">\n");

        $numres = array("10", "20", "50", "100", "200", "500");
        foreach ($numres as $element)
        {
            if ($element==$_GET["fNumResults"])
                printf("<option value=\"%s\" selected>%3s</option>\n", $element, $element);
            else
                printf("<option value=\"%s\">%3s</option>\n", $element, $element);
        }
        printf(" </select>\n");
        printf(" &nbsp;&nbsp;&nbsp;\n");

        ini_set("mysql.trace_mode", "Off");
        ini_set("display_errors", "Off");

        printf("<input class='Width' type='submit' value='Query Table'>&nbsp;&nbsp;&nbsp;\n");
        printf("<input class='Width' type='button' value='Reset' onClick='self.location.href=\"querystar.php\"'>&nbsp;&nbsp;&nbsp;\n");
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Get .txt' onClick='self.location.href=\"%s&fSendTxt=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        printf("</form>\n");
        printf("</center>\n");
        printf("</td>\n");
        printf("</tr>\n");
        printf("<tr class='Block'>\n");
        printf("<td>\n");
    }

    function PrintPage($html, $host, $user, $pw, $db, $alias, $rightalign, $checkwhere)
    {
        $db_id = mysql_connect($host, $user, $pw);
        if ($db_id==FALSE)
        {
            printf("mysql_connect returned the following error: %s\n", mysql_error());
            die("");
        }
        mysql_select_db($db);

        $query0 = CreateQuery($_GET, $alias, $checkwhere);

        $result0 = mysql_query($query0, $db_id);

        if ($result0)
        {
            if ($html=="1")
                PrintMagicTable($result0, $alias, $rightalign, "", "", "", $_GET);
            else
                PrintText($result0);

            mysql_free_result($result0);
        }
        mysql_close($db_id);

        PrintSubmittedQuery($query0, $html, $db, "old");
    }

    include ("include.php");
    include ("db.php");
    include ("magicdefs.php");

    ini_set("display_errors", "On");
    ini_set("mysql.trace_mode", "On");

    if (!empty($_GET["fSendTxt"]))
    {
        header("Content-type: application/octet");
        header("Content-Disposition: attachment; filename=query-result.txt");

        PrintPage("0", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere);
    }
    else
    {
        echo (file_get_contents("index-header.html"));

        $environment = sizeof($_GET);

        InitGet($_GET);
        PrintForm($_GET, $host, $user, $pw, $db);

        if ($environment==0)
            printf("No query submitted yet.<BR>");
        else
            PrintPage("1", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere);

        echo (file_get_contents("index-footer.html"));
    }

    ini_set("display_errors", "Off");
    ini_set("mysql.trace_mode", "Off");
}
?>
