#ifndef MARS_MHexagon
#define MARS_MHexagon

//////////////////////////////////////////////////////////////
//
//   MHexagon
//
//   A Hexagon for the MAGIC event display
//
//////////////////////////////////////////////////////////////

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef ROOT_TObject
#include <TObject.h>
#endif 

#ifndef ROOT_TAttLine
#include <TAttLine.h>
#endif 

#ifndef ROOT_TAttFill
#include <TAttFill.h>
#endif 

class MGeomPix;

class MHexagon : public TObject, public TAttLine, public TAttFill
{
protected:

    Float_t fX;  // X coordinate  of center
    Float_t fY;  // Y coordinate  of center
    Float_t fD;  // diameter D or better distance between opposite sides

public:

    MHexagon();
    MHexagon(Float_t x, Float_t y, Float_t d);
    MHexagon(const MGeomPix &pix);
    MHexagon(const MHexagon &hexagon);

    virtual void  Copy(TObject &hexagon)
#if ROOT_VERSION_CODE > ROOT_VERSION(3,04,01)
const
#endif
        ;

    Int_t DistancetoPrimitive(Int_t px, Int_t py, Float_t conv);
    virtual Int_t DistancetoPrimitive(Int_t px, Int_t py)
    {
        return DistancetoPrimitive(px, py, 1);
    }
    virtual Float_t DistanceToPrimitive(Float_t px, Float_t py);
    virtual void  DrawHexagon(Float_t x, Float_t y, Float_t d);

    //virtual void  ExecuteEvent(Int_t event, Int_t px, Int_t py);

    virtual void  ls(const Option_t *Option="") const;
    virtual void  Paint(Option_t *Option="");
    virtual void  PaintHexagon(Float_t x, Float_t y, Float_t d);
    virtual void  Print(Option_t *Option="") const; // *MENU*
    virtual void  SavePrimitive(ostream &out, Option_t *);
    virtual void  SavePrimitive(ofstream &out, Option_t *);

    Float_t GetX() const { return fX; }
    Float_t GetY() const { return fY; }
    Float_t GetD() const { return fD; }

    ClassDef(MHexagon, 1)    // A hexagon for MAGIC
};

#endif

