#ifndef MARS_MPointingPositionCalc
#define MARS_MPointingPositionCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

class MPointing;
class MPointingDev;
class MRawRunHeader;
class MReportStarguider;

class MPointingDevCalc : public MTask
{
private:
    static const TString fgFileName; //! default file name of pointing model

    MReportStarguider *fReport;    //! MReportStarguider to get mispointing
    MPointingDev      *fDeviation; //! Output container to store pointing deviation
    MPointing         *fPointing;  //! MPointing, pointing model for the calibration

    UShort_t fRunType;             //! Run Type to decide where to get pointing position from

    Double_t fNsbSum;              //! Sum of Nsb from Starguider
    Double_t fNsbSq;               //! Sum of Sq of Nsb from Starguider
    Int_t    fNsbCount;            //! Counter of Nsb entries from Starguider

    TArrayI  fSkip;                //! Counter for execution statistics
    Double_t fLastMjd;             //! Time of last processed report

    TString fFileName;             // File name of pointing model

    UInt_t  fNumMinStars;          // Minimum number of identified stars
    Float_t fNsbLevel;             // Minimum deviation from mean in sigma
    Float_t fNsbMin;               // Minimum NSB to calc mean and rms
    Float_t fNsbMax;               // Maximum NSB to calc mean and rms
    Float_t fMaxAbsDev;            // [arcmin] Maximum considered absolute deviation
    Float_t fMaxAge;               // [min] Maximum age of reports to be used without an update

    Float_t fDx;                   // Starguider calibration dx
    Float_t fDy;                   // Starguider calibration dy

    // MPointingDevCalc
    void DoCalibration(Double_t devzd, Double_t devaz) const;

    Bool_t ReadPointingModel(const MRawRunHeader &run);

    Int_t ProcessStarguiderReport();
    void  Skip(Int_t i);

    // MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    // MTask
    Bool_t ReInit(MParList *plist);
    Int_t  PreProcess(MParList *plist);
    Int_t  Process();
    Int_t  PostProcess();

public:
    MPointingDevCalc() : fReport(0), fDeviation(0), fPointing(0),
        fSkip(7), fFileName(fgFileName), fNumMinStars(8),
        fNsbLevel(3), fNsbMin(30), fNsbMax(60), fMaxAbsDev(15),
        fMaxAge(1), fDx(-7), fDy(16)
    {
        fName  = "MPointingDevCalc";
        fTitle = "Task calculating the pointing deviation";

        AddToBranchList("MReportStarguider.*");
    }
    ~MPointingDevCalc()
    {
        Clear();
    }

    void Clear(Option_t *o="");

    void SetNumMinStars(UInt_t n)  { fNumMinStars=n; }
    void SetNsbLevel(Float_t lvl)  { fNsbLevel=lvl;  }
    void SetNsbMin(Float_t nsb)    { fNsbMin=nsb;    }
    void SetNsbMax(Float_t nsb)    { fNsbMax=nsb;    }
    void SetMaxAbsDev(Float_t max) { fMaxAbsDev=max; }
    void SetDx(Float_t dx)         { fDx=dx; }
    void SetDy(Float_t dy)         { fDy=dy; }
    void SetMaxAge(Float_t age)    { fMaxAge=age; }

    ClassDef(MPointingDevCalc, 0) //Task calculating the pointing deviation
};

#endif
