#ifndef MARS_MSrcPosCalc
#define MARS_MSrcPosCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TVector2
#include <TVector2.h>
#endif

class MObservatory;
class MPointingPos;
class MPointingDev;
class MSrcPosCam;
class MGeomCam;
class MTime;
class MVector3;
class MTaskList;

class MSrcPosCalc : public MTask
{
public:
    enum Mode_t {
        kDefault = 0,
        kOffData = 1,
        kWobble  = 2
    };
private:
    enum {
        kIsOwner = BIT(14)
    };

    MObservatory *fObservatory;
    MPointingPos *fPointPos;
    MPointingPos *fSourcePos;
    MPointingDev *fDeviation;
    MSrcPosCam   *fSrcPosCam;
    MSrcPosCam   *fSrcPosAnti;
    MGeomCam     *fGeom;
    MTime        *fTime;
    MTaskList    *fCallback;

    UShort_t fRunType;            //! Run Type to decide where to get pointing position from

    Int_t fMode;

    // MSrcPosCalc
    void     SetSrcPos(TVector2 v=TVector2()) const;
    TVector2 CalcXYinCamera(const MVector3 &pos0, const MVector3 &pos) const;
    TString  GetRaDec(const MPointingPos &pos) const;
    Bool_t   GetCoordinate(TString str, Double_t &ret) const;
    void     FreeSourcePos();

    // MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    // MTask
    Bool_t ReInit(MParList *pList);
    Int_t  PreProcess(MParList *pList);
    Int_t  Process();

public:
    MSrcPosCalc(const char *name=NULL, const char *title=NULL);
    ~MSrcPosCalc() { FreeSourcePos(); }

    // MSrcPosCalc
    void SetSourcePos(MPointingPos *pos) { FreeSourcePos(); fSourcePos = pos; }
    void SetSourcePos(Double_t ra, Double_t dec);
    void SetOwner(Bool_t b=kTRUE) { b ? SetBit(kIsOwner) : ResetBit(kIsOwner); } // Make MSrcPosCalc owner of fSourcePos
    void SetMode(Mode_t m=kDefault) { fMode = m; }
    void SetCallback(MTaskList *list) { fCallback=list; }

    ClassDef(MSrcPosCalc, 0) // Calculates the source position in the camera
};

#endif
