#ifndef MARS_MJTrainDisp
#define MARS_MJTrainDisp

#ifndef MARS_MJTrainRanForest
#include "MJTrainRanForest.h"
#endif

class TCanvas;

class MH3;
class MDataSet;

class MJTrainDisp : public MJTrainRanForest
{
private:
    static const TString fgTrainParameter;

    TString fTrainParameter;

    void DisplayHist(TCanvas &c, Int_t i, MH3 &mh3) const;
    void DisplayResult(MH3 &hsize, MH3 &henergy);

public:
    MJTrainDisp() : fTrainParameter(fgTrainParameter) { }

    void SetTrainParameter(const char *txt) { fTrainParameter=txt; }

    Bool_t Train(const char *out, const MDataSet &set, Int_t num);
    //Bool_t TrainGhostbuster(const char *out, const MDataSet &set, Int_t num);

    ClassDef(MJTrainDisp, 0)//Class to train Random Forest disp estimator
};

#endif
