void getRate(int dim=0, char *filename = "/big0/Maggi/CamData/Gamma/gamma_15_on.root" )
{
    // This macro has two input parameter:
    // dim : = 0 -> root file with 1 trigger condition.
    //       > 0 -> number of trigger condition to be analised 
    //              in multi conditon file.
    //       < 0 -> selects the -dim trigger condition.
    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    //
    // Setup the parameter list.
    //  - we do not need to create any other container. All of them
    //    are created automatically without loss - we don't have to
    //    access them-
    //
    
    parlist.AddToList(&tasklist);

    //
    // Setup out tasks:
    //  - First we have to read the events
    //  - Then we can calculate rates, for what the number of
    //    triggered showers from a empty reflector file for the
    //    analised trigger conditions should be set (BgR[])
    //
    MReadTree reader("Events", filename);
    tasklist.AddToList(&reader);

    Float_t BgR[10]={20907,352,0,0,0,0,0,0,0,0};
    cout<<dim<<endl;

    MMcTriggerRateCalc rate(dim, 14, BgR, 100000, 2.75, 10.91e-2);
    tasklist.AddToList(&rate);

    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    magic.Eventloop();

}
