#ifndef MARS_MReportCC
#define MARS_MReportCC

#ifndef MARS_MReport
#include "MReport.h"
#endif

class MReportRec;
class MCameraTH;
class MCameraTD;
class MCameraRecTemp;

class MReportCC : public MReport
{
private:
    Float_t fHumidity;        // [%]
    Float_t fTemperature;     // [deg] celsius
    Float_t fWindSpeed;       // [km/h]
    Float_t fSolarRadiation;  // [W/m^2] IR-Radiation

    Float_t fUPSStatus;       // arbitrary units (still not properly defined)
    Float_t fDifRubGPS;       // [us] Difference between the Rubidium clock time and the time provided by the GPS receiver

    MCameraTH      *fTH;      //! Discriminator thresholds
    MCameraTD      *fTD;      //! Discriminator delays
    MCameraRecTemp *fRecTemp; //! Receiver Board temperatures

    MReportRec     *fRecRep;  //! Pipe interpretation to MReportRec if necessary

    // Internal
    Bool_t SetupReading(MParList &plist);
    Bool_t InterpreteCC(TString &str, Int_t ver);

    // MReport
    Int_t InterpreteBody(TString &str, Int_t ver);

public:
    MReportCC();

    Float_t GetHumidity() const       { return fHumidity; }
    Float_t GetTemperature() const    { return fTemperature; }
    Float_t GetWindSpeed() const      { return fWindSpeed; }
    Float_t GetSolarRadiation() const { return fSolarRadiation; }

    void Print(Option_t *opt) const;

    ClassDef(MReportCC, 2) // Class for CC-REPORT information
};

#endif
