#ifndef MARS_MParEmulated
#define MARS_MParEmulated

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MParEmulated : public MParContainer
{
private:
    Byte_t *fPtr;
    TString fClassName;

#ifndef __CINT__
#if ROOT_VERSION_CODE<ROOT_VERSION(5,18,00)
    TStreamerInfo *GetStreamerInfo(const TString &clsname) const;
#else
    TVirtualStreamerInfo *GetStreamerInfo(const TString &clsname) const;
#endif
#endif
    TMethodCall *GetMethodCall(const char *get, Int_t offset) const;

public:
    MParEmulated(const char *name=0, const char *title=0);

    void SetClassName(const char *name) { fClassName=name; }

    Byte_t **GetPtr() { return &fPtr; }

    Int_t    GetInt(Int_t offset) const { return *reinterpret_cast<Int_t*>   (fPtr+offset); }
    Double_t GetDouble(Int_t offset) const { return *reinterpret_cast<Double_t*>(fPtr+offset); }

    TMethodCall *GetterMethod(const char *name, TString cls, Int_t offset=0) const;
    TMethodCall *GetterMethod(const char *name) const { return GetterMethod(name, fClassName); }

    void Print(TPRegexp &regex, TString classname, TString prefix, Int_t offset) const;
    void Print(Option_t *o=0) const;

    ClassDef(MParEmulated, 0) // Storage container for emulated classes from files
};

#endif
