<?php
{
    function CreateQuery($_GET, $alias, $checkwhere, $checkgroup, $checkstatusgroup, $needs)
    {
        $fromtable="DataSets";

        $groups = 0;
        foreach ($checkgroup as $element)
            if ($element==-1)
                $groups++;

        $statusgroups = 0;
        foreach ($checkstatusgroup as $element)
            if ($element==-1)
                $statusgroups++;

        $query0 = "SELECT ";

        if ($groups>0)
        {
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                    $query0 .=  $key . " as '" . $alias[$key] . "' " . ", ";
            $query0 .= " COUNT(*) as '# Datasets' ";
        }
        else
        {
            if ($statusgroups>0)
            {
                foreach ($checkstatusgroup as $key => $element)
                    if ($element==-1)
                        $query0 .= " (if(IsNull(" . $key . "), if(isnull(fStartTime), 'not done', if(isnull(fFailedTime),if(isnull(" . $needs[$key] . "),'not done',if(date_sub(Now(),interval 12 hour) < fStartTime,'running','crashed')),if(isnull(" . $needs[$key] . "),'not done','failed'))) ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";
//                        $query0 .= " (if(IsNull(" . $key . "), 'not done' ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";

                $query0 .= " COUNT(*) as '# Datasets'";

            }
            else
            {
                $query0 .= " " . $fromtable . ".fDataSetNumber as '" . $alias["fDataSetNumber"] . "' ";
                if (!empty($_GET["fLinks"]))
                {
                    $query0 .= ", CONCAT('<A&ws;HREF=\"http://www.astro.uni-wuerzburg.de/datacenter/datasets/' , LEFT(LPAD(CONCAT(DataSets.fDataSetNumber, '.'), 9,'0'),5), '/dataset', LPAD(CONCAT(DataSets.fDataSetNumber , '.txt'), 12,'0') , '\">f</A>' ";
                    $query0 .= ", '&nbsp;<A&ws;HREF=\"http://www.astro.uni-wuerzburg.de/datacenter/ganymed/' , LEFT(LPAD(CONCAT(DataSets.fDataSetNumber, '.'), 9,'0'),5), '/', LEFT(LPAD(CONCAT(DataSets.fDataSetNumber, '.'), 9,'0'), 8), '\">g</A>'";
                    $query0 .= ", '&nbsp;<A&ws;HREF=\"ganymed.php?fDataSetNo=', DataSets.fDataSetNumber, '\">i</A>') ";
                    $query0 .= " as 'Links'";
                }

                foreach ($_GET as $key => $element)
                    if ($_GET[$key]=="On")
                        if ($key!="fLinks")
                            if (empty($checkwhere[$key]) || $checkwhere[$key]==0)
                                $query0 .= ", " . $key . " as '" . $alias[$key] . "' ";
            }
        }

        $query0 .= " FROM " . $fromtable;

        $query0 .= " LEFT JOIN DataSetProcessStatus USING(fDataSetNumber) ";
        $query0 .= " LEFT JOIN Ganymed USING(fDataSetNumber) ";

        foreach ($_GET as $key => $element)
            if (($_GET[$key]=="On" || $groups>0))// && !empty($joins[$key]))
                $query0 .= GetJoin($fromtable,$key);

        foreach ($checkwhere as $key => $element)
        {
            if (empty($element) || $element<=0)
                continue;

            if (strpos($query0, " WHERE ")==FALSE)
                $query0 .= " WHERE ";
            else
                if ($element!=-1)
                    if (strrpos($query0, " AND ")!=strlen($query0)-5)
                        $query0 .= " AND ";

            if ($element!=-1)
                $query0 .= GetCheck($fromtable, $key) . "=" . $element;
        }

        if (strpos($query0, " WHERE ")==FALSE)
            $query0 .= " WHERE ";
        else
            $query0 .= " AND ";

        $query0 .= StatusQuery("fDataSetInserted", $needs);
        $query0 .= StatusQuery("fStarFilesAvail", $needs);
        $query0 .= StatusQuery("fGanymed", $needs);
        $query0 .= StatusQuery("fFillGanymed", $needs);

        if (!empty($_GET["fRunMin"]) && !empty($_GET["fRunMax"]))
            $query0 .= "DataSets.fDataSetNumber BETWEEN " . $_GET["fRunMin"] . " AND " . $_GET["fRunMax"] . " ";

/*
        if (!empty($_GET["fDate"]))
            $query0 .= " AND fRunStart REGEXP \"^" . $_GET["fDate"] . "\" ";
*/

        if (!empty($_GET["fSourceN"]))
            $query0 .= " AND fSourceName REGEXP \"^" . $_GET["fSourceN"] . "\" ";

        if ($groups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $groups;
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= GetCheck($fromtable,$key);
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if ($statusgroups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $statusgroups;
            foreach ($checkstatusgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= $alias[$key];
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if (!empty($_GET["fSortBy"]))
        {
            $val=substr($_GET["fSortBy"], 0, -1);
            $query0 .= " ORDER BY " . GetTable($fromtable, $val) . " ";
            if (substr($_GET["fSortBy"], -1)=="-")
                $query0 .= "DESC";
        }

        if (empty($_GET["fSortBy"]) && $groups==0 && $statusgroups==0)
            $query0 .= "ORDER BY DataSets.fDataSetNumber ASC ";

        if (empty($_GET["fNumStart"]))
            $_GET["fNumStart"]=0;

        if (empty($_GET["fSendTxt"]))
            $query0 .= " LIMIT " . $_GET["fNumStart"] . ", " . $_GET["fNumResults"];

        return $query0;
    }

    function InitGet($_GET)
    {
        // Find out whether it is the first call to the php script
        $first = empty($_GET["fRunMin"]) && empty($_GET["fRunMax"]);

        if (empty($_GET["fNumResults"]))
            $_GET["fNumResults"]="50";

        if (empty($_GET["fLastUpdate"]))
            $_GET["fLastUpdate"]="Off";

        if (empty($_GET["fLinks"]))
            $_GET["fLinks"]=$first?"On":"";

        if (empty($_GET["fComment"]))
            $_GET["fComment"]="Off";

        if (empty($_GET["fWobble"]))
            $_GET["fWobble"]=$first?"On":"";

        if (empty($_GET["fExcessEvents"]))
            $_GET["fExcessEvents"]=$first?"On":"";

        if (empty($_GET["fExcessEvents*60/fEffOnTime"]))
            $_GET["fExcessEvents*60/fEffOnTime"]=$first?"Off":"";

        if (empty($_GET["fBackgroundEvents*60/fEffOnTime"]))
            $_GET["fBackgroundEvents*60/fEffOnTime"]=$first?"On":"";

        if (empty($_GET["fBackgroundEvents"]))
            $_GET["fBackgroundEvents"]=$first?"On":"";

        if (empty($_GET["fSignalEvents"]))
            $_GET["fSignalEvents"]=$first?"On":"";

        if (empty($_GET["fSignalEvents*60/fEffOnTime"]))
            $_GET["fSignalEvents*60/fEffOnTime"]=$first?"Off":"";

        if (empty($_GET["fSignificance"]))
            $_GET["fSignificance"]=$first?"On":"";

        if (empty($_GET["Round(fSignificance/Sqrt(fEffOnTime/3600),2)"]))
            $_GET["Round(fSignificance/Sqrt(fEffOnTime/3600),2)"]=$first?"Off":"";

        if (empty($_GET["fScaleFactor"]))
            $_GET["fScaleFactor"]=$first?"On":"";

        if (empty($_GET["fEffOnTime/3600"]))
            $_GET["fEffOnTime/3600"]=$first?"On":"";

        if (empty($_GET["fDataSetInserted"]))
            $_GET["fDataSetInserted"]="Off";

        if (empty($_GET["fDataSetInsertedStatus"]))
            $_GET["fDataSetInsertedStatus"]="0";

        if (empty($_GET["fStarFilesAvail"]))
            $_GET["fStarFilesAvail"]="Off";

        if (empty($_GET["fStarFilesAvailStatus"]))
            $_GET["fStarFilesAvailStatus"]="0";

        if (empty($_GET["fGanymed"]))
            $_GET["fGanymed"]=$first?"On":"";

        if (empty($_GET["fGanymedStatus"]))
            $_GET["fGanymedStatus"]="0";

        if (empty($_GET["fFillGanymed"]))
            $_GET["fFillGanymed"]="Off";

        if (empty($_GET["fFillGanymedStatus"]))
            $_GET["fFillGanymedStatus"]="0";

        if (empty($_GET["fSourceName"]))
            $_GET["fSourceName"]=$first?"On":"";

        if (empty($_GET["fLastUpdate"]))
            $_GET["fLastUpdate"]="Off";

        if (empty($_GET["fStartTime"]))
            $_GET["fStartTime"]="Off";

        if (empty($_GET["fFailedTime"]))
            $_GET["fFailedTime"]="Off";

        if (empty($_GET["fReturnCode"]))
            $_GET["fReturnCode"]="Off";

        if (empty($_GET["fProgramId"]))
            $_GET["fProgramId"]="Off";

    }

    function PrintForm($_GET, $host, $user, $pw, $db)
    {
        printf("<center>\n");
        printf("<form action=\"datasetinfo.php\" METHOD=\"GET\">\n");
        printf(" <table>\n");
        printf("  <tr>\n");

        CheckBox("fWobble",           "Wobble");
        CheckBox("fComment",          "Comment");
        CheckBox("fScaleFactor",      "Scale");
        CheckBox("fEffOnTime/3600",   "EffOnTime");
        CheckBox("fLinks",             "Links");

        printf("  </tr><tr>\n");

        CheckBox("fExcessEvents",     "ExcEvts");
        CheckBox("fBackgroundEvents", "BgEvts");
        CheckBox("fSignalEvents",     "SignEvts");
        CheckBox("fSignificance",     "Sign");

        printf("  </tr><tr>\n");       

        CheckBox("fExcessEvents*60/fEffOnTime",                   "ExcRate");
        CheckBox("fBackgroundEvents*60/fEffOnTime",               "BgRate");
        CheckBox("fSignalEvents*60/fEffOnTime",                   "SignRate");
        CheckBox("Round(fSignificance/Sqrt(fEffOnTime/3600),2)",  "SignfRate");

        printf("  </tr>\n");
        printf(" </table>\n");
        printf(" <p>\n");
        printf(" <table>\n");
        printf("  <tr>\n");

        CheckBox("fStartTime",     "StartTime");
        CheckBox("fFailedTime",    "FailedTime");
        CheckBox("fReturnCode",    "RetCode");
        CheckBox("fProgramId",     "ProgramId");

        printf("  </tr>\n");
        printf(" </table>\n");
        printf(" <table>\n");
        printf("  <tr>\n");

        printf("  <td>\n");
        PrintStatusMenu("fDataSetInserted", "DataSet Inserted");
        printf("  </td><td>\n");
        PrintStatusMenu("fStarFilesAvail",  "FilesAvail");
        printf("  </td><td>\n");
        PrintStatusMenu("fGanymed",         "Ganymed");
        printf("  </td><td>\n");
        PrintStatusMenu("fFillGanymed",     "FillGanymed");

        printf("  </td></tr><tr><td>\n");

        PrintPullDown($host, $user, $pw, $db, "Source",      "fSourceName",      "fSourceKEY", "Source Name");

        printf("  </td></tr>\n");
        printf(" </table>\n");
        printf(" <p>\n");

        if (empty($_GET["fRunMin"]))
            $min = GetMin("fDataSetNumber", "DataSets", $host, $user, $pw, $db);
        else
            $min = $_GET["fRunMin"];

        if (empty($_GET["fRunMax"]))
            $max = GetMax("fDataSetNumber", "DataSets", $host, $user, $pw, $db);
        else
            $max = $_GET["fRunMax"];

/*
        printf("Date&nbsp;(yyyy-mm-dd)&nbsp;<input name=\"fDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"");
        if (!empty($_GET["fDate"]))
            printf("%s", $_GET["fDate"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");
*/

        printf("Source&nbsp;(<A HREF=\"regexp.html\">regexp</A>)&nbsp;<input name=\"fSourceN\" type=\"text\" size=\"15\" maxlength=\"15\" value=\"");
        if (!empty($_GET["fSourceN"]))
            printf("%s", $_GET["fSourceN"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");

        printf("DataSets&nbsp;from&nbsp;<input name=\"fRunMin\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">\n", $min);
        printf("to&nbsp;<input name=\"fRunMax\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">&nbsp;&nbsp;&nbsp;\n", $max);

        printf(" <P>\n");

        printf(" Results:\n");
        printf(" <select name=\"fNumResults\">\n");

        $numres = array("10", "20", "50", "100", "200", "500");
        foreach ($numres as $element)
        {
            if ($element==$_GET["fNumResults"])
                printf("<option value=\"%s\" selected>%3s</option>\n", $element, $element);
            else
                printf("<option value=\"%s\">%3s</option>\n", $element, $element);
        }
        printf(" </select>\n");
        printf(" &nbsp;&nbsp;&nbsp;\n");

        ini_set("mysql.trace_mode", "Off");
        ini_set("display_errors", "Off");

        printf("<input class='Width' type='submit' value='Query Table'>&nbsp;&nbsp;&nbsp;\n");
        printf("<input class='Width' type='button' value='Reset' onClick='self.location.href=\"datasetinfo.php\"'>&nbsp;&nbsp;&nbsp;\n");
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Get .txt' onClick='self.location.href=\"%s&fSendTxt=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Print' onClick='self.location.href=\"%s&fPrintTable=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        printf("</form>\n");
        printf("</center>\n");
        printf("</td>\n");
        printf("</tr>\n");
        printf("<tr class='Block'>\n");
        printf("<td>\n");
    }

    function PrintPage($html, $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $needs)
    {
        $db_id = mysql_connect($host, $user, $pw);
        if ($db_id==FALSE)
        {
            printf("mysql_connect returned the following error: %s\n", mysql_error());
            die("");
        }
        mysql_select_db($db);

        $query0 = CreateQuery($_GET, $alias, $checkwhere, $checkgroup, $checkstatusgroup, $needs);

        $result0 = mysql_query($query0, $db_id);

        if ($result0)
        {
            if ($html=="1" || $html=="2")
                PrintMagicTable($result0, $alias, $rightalign, "", "", "", "", $_GET);
            else
                PrintText($result0);

            mysql_free_result($result0);
        }
        mysql_close($db_id);

        PrintSubmittedQuery($query0, $html, $db, "old");
    }

    include ("include.php");
    include ("db.php");
    include ("magicdefs.php");

    ini_set("display_errors", "On");
    ini_set("mysql.trace_mode", "On");

    if (!empty($_GET["fSendTxt"]))
    {
        header("Content-type: application/octet");
        header("Content-Disposition: attachment; filename=query-result.txt");

        PrintPage("0", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup);
    }
    else
    {
        echo (file_get_contents("index-header.html"));

        $environment = sizeof($_GET);

        InitGet($_GET);
        if (empty($_GET["fPrintTable"]))
            PrintForm($_GET, $host, $user, $pw, $db);

        if ($environment==0)
            printf("No query submitted yet.<BR>");
        else
        {
            if (empty($_GET["fPrintTable"]))
                PrintPage("1", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $needs);
            else
                PrintPage("2", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere, $checkgroup, $checkstatusgroup, $needs);
        }

        echo (file_get_contents("index-footer.html"));
    }

    ini_set("display_errors", "Off");
    ini_set("mysql.trace_mode", "Off");
}
?>
