#ifndef MARS_MAvalanchePhotoDiode
#define MARS_MAvalanchePhotoDiode

#ifndef ROOT_TH2
#include <TH2.h>
#endif

class APD : public TObject
{
private:
    TH2F fHist;

    Float_t fCrosstalkProb;  // Probability that a converted photon creates another one in a neighboring cell
    Float_t fDeadTime;       // Deadtime of a single cell after a hit
    Float_t fRecoveryTime;   // Recoverytime after Deadtime (1-exp(-t/fRecoveryTime)

    Float_t HitCellImp(Int_t x, Int_t y, Float_t t=0);

public:
    APD(Int_t n, Float_t prob=0, Float_t dt=0, Float_t rt=0);

    Float_t HitCell(Int_t x, Int_t y, Float_t t=0);
    Float_t HitRandomCell(Float_t t=0);

    void FillEmpty(Float_t t=0);
    void FillRandom(Float_t rate, Float_t t=0);

    Int_t CountDeadCells(Float_t t=0) const;
    Int_t CountRecoveringCells(Float_t t=0) const;

    ClassDef(APD, 1) // An object representing a Geigermode APD
};

#endif
