#ifndef MARS_MMirrorSquare
#define MARS_MMirrorSquare

#ifndef MARS_MMirror
#include "MMirror.h"
#endif

class MMirrorSquare : public MMirror
{
private:
    Double_t fSideLength; // HALF of the side length!
public:
    MMirrorSquare() : fSideLength(24.75) { }

    Double_t GetMaxR() const { return TMath::Sqrt(2.)*fSideLength; }

    // This should fit with Paint()
    Bool_t HasHit(const MQuaternion &p) const;
    // This should fit with HasHit()
    void Paint(Option_t *);
    Bool_t CanHit(const MQuaternion &p) const;
    Int_t ReadM(const TObjArray &tok);

    ClassDef(MMirrorSquare, 0) // A spherical square type mirror
};

#endif
