#ifndef MARS_MMirrorDisk
#define MARS_MMirrorDisk

#ifndef MARS_MMirror
#include "MMirror.h"
#endif

class MMirrorDisk : public MMirror
{
private:
    Double_t fR;

public:
    MMirrorDisk() : fR(24.75) { }

    Double_t GetMaxR() const { return fR; }

    // This should fit with Paint()
    Bool_t HasHit(const MQuaternion &p) const;
    // This should fit with HasHit()
    void Paint(Option_t *);
    Bool_t CanHit(const MQuaternion &p) const;
    Int_t ReadM(const TObjArray &tok);

    ClassDef(MMirrorDisk, 0)  // A spherical disk type mirror
};

#endif
