#ifndef MARS_MLut
#define MARS_MLut

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#include <iosfwd>

class MArrayI;

class MLut : public TObjArray
{
private:
    UInt_t fMinEntries;
    UInt_t fMaxEntries;

    Int_t  fMaxIndex;

    MLut *GetInverse(Bool_t uniq=kTRUE) const;

public:
    MLut() : fMinEntries(0), fMaxEntries(0) { SetOwner(); }

    // MLut Getter
    const MArrayI &GetRow(UInt_t i) const;

    UInt_t GetMaxEntries() const { return fMaxEntries; }
     Int_t GetMaxIndex() const { return fMaxIndex; }

    Bool_t HasConstantLength() const { return fMinEntries==fMaxEntries; }
    Bool_t IsEmpty() const { return fMaxEntries==0; }

    // MLut convertions
    void SetInverse(const MLut &lut, Bool_t uniq=kTRUE);
    void Invert(Bool_t uniq=kTRUE);

    // MLut I/O
    Int_t ReadStream(istream &in);
    Int_t WriteStream(ostream &out);

    Int_t ReadFile(const char *fname);
    Int_t WriteFile(const char *fname);

    ClassDef(MLut, 1) // A simple and fast easy-to-use look-up-table
};

#endif
