#ifndef MARS_MSpline3
#define MARS_MSpline3

#ifndef ROOT_TSpline
#include <TSpline.h>
#endif

class MSpline3 : public TSpline3
{
private:
    TGraph *ConvertSpline(const TSpline &s, Float_t freq) const;
    TGraph *ConvertGraph(const TGraph &s, Float_t freq) const;
    TGraph *ConvertFunc(const TF1 &f, Float_t freq) const;

public:
   MSpline3(const TGraph &g,
            const char *opt=0, Double_t valbeg=0, Double_t valend=0)
        : TSpline3("MSpline3", &g, opt, valbeg, valend)
   {
   }

   MSpline3(const TGraph &g, Double_t freq,
            const char *opt=0, Double_t valbeg=0, Double_t valend=0)
        : TSpline3("MSpline3", ConvertGraph(g, freq), opt, valbeg, valend)
   {
   }

   MSpline3(const TSpline &s, Double_t freq,
            const char *opt=0, Double_t valbeg=0, Double_t valend=0)
        : TSpline3("MSpline3", ConvertSpline(s, freq), opt, valbeg, valend)
   {
   }
        /*
   MSpline3(Double_t xmin, Double_t xmax,
            const TF1 *func, Int_t n, const char *opt=0,
            Double_t valbeg=0, Double_t valend=0)
        : TSpline3("MSpline3", xmin, xmax, func, n, opt, valbeg, valend)
   {
   }*/
   MSpline3(const TF1 &f, const char *opt=0,Double_t valbeg=0, Double_t valend=0);

   MSpline3(const TF1 &f, Double_t freq,
            const char *opt=0,Double_t valbeg=0, Double_t valend=0)
        : TSpline3("MSpline3", ConvertFunc(f, freq), opt, valbeg, valend)
   {
   }

   MSpline3(const Double_t x[], const Double_t y[], Int_t n, const char *opt=0,
            Double_t valbeg=0, Double_t valend=0)
        : TSpline3("MSpline3", const_cast<Double_t*>(x), const_cast<Double_t*>(y), n, opt, valbeg, valend)
   {
   }

   Double_t GetXmin() const { return fXmin; }     // Minimum value of abscissa
   Double_t GetXmax() const { return fXmax; }     // Maximum value of abscissa

   Int_t GetNp() const { return fNp; }

   ClassDef(MSpline3, 1) // An extension of the TSpline3
};

#endif
