#ifndef MARS_MHNewImagePar2
#define MARS_MHNewImagePar2

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MHillas;

class MHNewImagePar2 : public MH
{
private:
    TH1F fHistBorder1;  //
    TH1F fHistBorder2;  //

    Float_t fMm2Deg;
    Bool_t  fUseMmScale;

public:
    MHNewImagePar2(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *plist);
    Int_t  Fill(const MParContainer *par, const Stat_t w=1);

    void SetMmScale(Bool_t mmscale=kTRUE);
    virtual void SetMm2Deg(Float_t mmdeg);

    void Draw(Option_t *opt="");

    ClassDef(MHNewImagePar2, 1) // Histograms of new image parameters
};

#endif


