#ifndef MARS_MJSimulation
#define MARS_MJSimulation

#ifndef MARS_MJob
#include "MJob.h"
#endif

class MHn;
class MArgs;

class MJSimulation : public MJob
{
private:
    Bool_t fForceMode;

    Bool_t WriteResult();
    Bool_t CheckEnvLocal();

    void SetupHist(MHn &hist) const;

public:
    MJSimulation(const char *name=NULL, const char *title=NULL);

    void SetForceMode(Bool_t force=kTRUE) { fForceMode = force; }

    // Process
    Bool_t Process(const MArgs &args);

    ClassDef(MJSimulation, 0) // Job to run the simulation (ceres)
};

#endif
