/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MCerPhotPix.h"

#include "MLog.h"

ClassImp(MCerPhotPix);

// --------------------------------------------------------------------------
//
// Default constructor. The pixel is assumed as used and not a core pixel.
//
MCerPhotPix::MCerPhotPix(Int_t pix, Float_t phot, Float_t errphot) :
    fPixId(pix), fIsUsed(kTRUE), fIsCore(kFALSE), fPhot(phot), fErrPhot(errphot)
{
} 

// --------------------------------------------------------------------------
//
// Sets the information of one pixel.  The pixel is assumed as used and
// not a core pixel.
//
void MCerPhotPix::SetPixelContent(Int_t pix, Float_t phot, Float_t errphot)
{
    fPixId   = pix;
    fIsUsed  = kTRUE;
    fPhot    = phot;
    fErrPhot = errphot;
}

// --------------------------------------------------------------------------
//
//  Print information to gLog.
//
void MCerPhotPix::Print(Option_t *)
{ 
    gLog << "MCerPhotPix: Pixel: "<< fPixId ;

    gLog << (fIsUsed?"    Used ":"  Unused ");

    gLog << (fIsCore?"  Core  ":"        ");

    gLog << "  Nphot= " << fPhot
        << "  Error(Nphot) = " << fErrPhot
        << endl ;
}

