#ifndef MPARLIST_H
#define MPARLIST_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MParList                                                                //
//                                                                         //
// List of parameter containers (MParContainer)                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TOrdCollection
#include "TOrdCollection.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MLog;

class MParList : public MParContainer
{
private:
    TOrdCollection fContainer;	// Collection of Parameter and Data Containers
    TOrdCollection fAutodelete; // All what this list contains is deleted in the destructor

    static TString GetClassName(const char *classname);
    static TString GetObjectName(const char *classname, const char *objname);

public:
    MParList(const char *name=NULL, const char *title=NULL);
    MParList(MParList &ts);

    ~MParList()
    {
    }

    Bool_t AddToList(MParContainer *obj, MParContainer *where = NULL);
    void   AddToList(TObjArray *list);

    void SetLogStream(MLog *log);

    TObject       *FindObject(const char *name) const;
    TObject       *FindObject(TObject *obj) const;
    MParContainer *FindCreateObj(const char *classname, const char *objname=NULL);

    TObjArray FindObjectList(const char *name, const UInt_t from, const UInt_t to=0) const;
    TObjArray FindCreateObjList(const char *cname, const UInt_t from, const UInt_t to=0, const char *oname=NULL);

    static TObjArray CreateObjList(const char *cname, const UInt_t from, const UInt_t to=0, const char *oname=NULL);

    void Reset();
    void SetReadyToSave(Bool_t flag=kTRUE);

    void Print(Option_t *t = NULL);

    ClassDef(MParList, 0) // list of parameter containers (MParContainer)
};

#endif
