#ifndef MBROWSER_H
#define MBROWSER_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class TList;
class TGListView;
class TGComboBox;
class TGPictureButton;
class TGFileContainer;

class MBrowser : public TGTransientFrame
{
private:
    TGComboBox        *fDir;

    TGPictureButton   *fCdup;
    TGPictureButton   *fListMode;
    TGPictureButton   *fDetail;

    TGFileContainer   *fFileCont;
    TGListView        *fFileView;

    const TGPicture   *fPic1;
    const TGPicture   *fPic2;
    const TGPicture   *fPic3;

    void CreateMenuBar();
    void CreateUpperFrame(TGCompositeFrame *frameup);
    void CreateLowerFrame(TGCompositeFrame *framelow);
    void CreateTab1(TGCompositeFrame *frame);
    void CreateDirListMenu(TGCompositeFrame *frame);
    void CreateDirListBox(TGCompositeFrame *frame);

protected:
    TList  *fList;
    Char_t  fInputFile[256];

    void DisplError(const char *txt);
    void DisplWarning(const char *txt);
    void DisplInfo(const char *txt);

    void ChangeDir(const char *txt=NULL);

    TGHorizontalFrame *fTop1;
    TGHorizontalFrame *fTop2;
    TGHorizontalFrame *fTop3;

 public: 
     MBrowser(const TGWindow *main=NULL, const TGWindow *p=NULL,
               const UInt_t w=500, const UInt_t h=500) ;

     virtual ~MBrowser();

     void   CloseWindow();

     Bool_t InputFileSelected();

     virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

     ClassDef(MBrowser, 0)   // Base class for the gui
} ; 

#endif


