#ifndef MPEDCALCPEDRUN_H
#define MPEDCALCPEDRUN_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedCalcPedRun                                                          //
//                                                                         //
// Evaluate the pedestals from pedestal runs                               //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MTASK_H
#include "MTask.h"
#endif

class MRawEvtData;
class MPedestalCam;

class MPedCalcPedRun : public MTask
{
    Byte_t fNumHiGainSamples;

    MRawEvtData  *fRawEvt;     // raw event data (time slices)
    MPedestalCam *fPedestals;  // Pedestals of all pixels in the camera

    Float_t CalcHiGainMean(Byte_t *ptr, const Byte_t *end) const;
    Float_t CalcHiGainRms(Byte_t *ptr, const Byte_t *end, Float_t higainped) const;
    Float_t CalcHiGainMeanErr(Float_t higainrms) const;
    Float_t CalcHiGainRmsErr(Float_t higainrms) const;

public:

    MPedCalcPedRun(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MPedCalcPedRun, 0)   // Task to calculate pedestals from pedestal runs raw data
};

#endif
