#ifndef MPEDESTALPIX_H
#define MPEDESTALPIX_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

class MPedestalPix : public TObject
{
private:
    Float_t fMean;     // mean value of pedestal (PMT offset)
    Float_t fSigma;    // sigma (standard deviation) of pedestal
    Float_t fMeanRms;  // root mean square of pedestal
    Float_t fSigmaRms; // root mean sqare of sigma of the pedestal

public:
    MPedestalPix();

    Float_t GetMean() const     { return fMean;     }
    Float_t GetSigma() const    { return fSigma;    }
    Float_t GetMeanRms() const  { return fMeanRms;  }
    Float_t GetSigmaRms() const { return fSigmaRms; }

    void SetMean(Float_t f)     { fMean = f;     }
    void SetSigma(Float_t f)    { fSigma = f;    }
    void SetMeanRms(Float_t f)  { fMeanRms = f;  }
    void SetSigmaRms(Float_t f) { fSigmaRms = f; }

    void SetPedestal(Float_t m, Float_t s) { fMean = m; fSigma = s; }
    void SetPedestalRms(Float_t m, Float_t s) { fMeanRms = m; fSigmaRms = s; }

    ClassDef(MPedestalPix, 1)	// Storage Container for Pedestal information of one pixel
};

#endif

