#ifndef MCERPHOTEVT_H
#define MCERPHOTEVT_H

#ifndef MAGIC_h
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MCerPhotPix;

class MCerPhotEvt : public MParContainer
{
private:
    UInt_t        fNumPixels;
    TClonesArray *fPixels;

public:
    MCerPhotEvt(const char *name=NULL, const char *title=NULL);
    ~MCerPhotEvt() { delete fPixels; }

    void Draw(Option_t* option = "");

    UInt_t GetNumPixels() const { return fNumPixels; }

    void AddPixel(Int_t id, Float_t nph, Float_t err);

    void Clear(Option_t *opt=NULL);
    void Print(Option_t *opt=NULL) const;

    Bool_t  IsPixelExisting(Int_t id) const;
    Bool_t  IsPixelUsed    (Int_t id) const;
    Bool_t  IsPixelCore    (Int_t id) const;

    Float_t GetNumPhotonsMin() const;
    Float_t GetNumPhotonsMax() const;

    MCerPhotPix &operator[](int i)       { return *(MCerPhotPix*)(fPixels->At(i)); }
    MCerPhotPix &operator[](int i) const { return *(MCerPhotPix*)(fPixels->At(i)); }

    ClassDef(MCerPhotEvt, 1)    // class for an event containing cerenkov photons
};

#endif

