#ifndef MFILE_H
#define MFILE_H

#include "Magic.h"

#include <fstream.h>

#include <TFile.h>

class MFileDescrIn;
class MFileDescrOut;

class MParContainer;

class MFile
{
protected:
    MFileDescrIn  *fIn;  //!
    MFileDescrOut *fOut; //!
public:
    MFile() : fIn(NULL), fOut(NULL) {}
    ~MFile();

    virtual MFileDescrIn *OpenInput(const char *fname, const char *cname)
    {
        return NULL;
    };

    virtual MFileDescrOut *OpenOutput(const char *fName, const char *cname, MParContainer **obj)
    {
        return NULL;
    };

    ClassDef(MFile, 1)
};

/*class MAsciiFile : public MFile
{
private:
public:
    void ReadNextEntry()
    {
        dest->ReadBinEntry(FILE *f);
    }
    };*/

class MMagicFileImp
{
public:
    void GetNBytes(fstream& fin, Byte_t *buffer, Char_t cnt);
    void PutNBytes(fstream& fout, Byte_t *buffer, Char_t cnt);
};

class MRootFile : public MFile, public TFile
{
public:
    MRootFile() : TFile() {}
    MRootFile(const char *fname, Option_t *option="", const char *ftitle="", Int_t compress=1)
        : TFile(fname, option, ftitle, compress)
    {
    }

    MFileDescrIn  *OpenInput(const char *fName, const char *cname);
    MFileDescrOut *OpenOutput(const char *fName, const char *cname, MParContainer **obj);

    ClassDef(MRootFile, 1)
};


class MMagicFile : public MFile
{
public:
    MMagicFile() {}
    MMagicFile(const char *fname, Option_t *option="") {}

    MFileDescrIn  *OpenInput(const char *fName, const char *cname);
    MFileDescrOut *OpenOutput(const char *fName, const char *cname, MParContainer **obj);

    ClassDef(MMagicFile, 1)
};
#endif
