#ifndef MRAWEVT_H
#define MRAWEVT_H

#include "Magic.h"

#include "MParContainer.h"

#include <TClonesArray.h>

class MRawEvt : public MParContainer
{

private:
    UInt_t EvtNo;		// Number of Event
    ULong_t fTimeStamp;		// Time of the Event
    UChar_t EvtStatus;		// Status of this event (DAQ, Pedestal, ..) 
    UShort_t Trig1st;		// Number of 1st level tiggers between 2 events
    UShort_t MultPixel;		// Multiplicity of the Pixels in this event   

    TClonesArray *Pixels;	// list of the events

public:

    MRawEvt(const char *name=NULL, const char *title=NULL);
    ~MRawEvt();

    MParContainer *New()
    {
	return new MRawEvt;
    }

    void Clear(Option_t *t = NULL);
    void Print(Option_t *t = NULL);

    void FillRandom(UInt_t, ULong_t, UShort_t);
    void FillHeader(UInt_t, ULong_t, UChar_t = 0);
    void FillPixel(UShort_t, Float_t*);
    void FillMontCarl(UInt_t, ULong_t, Float_t*);

    UShort_t GetMultPixel();
    Int_t GetPixelId(Int_t iList);
    UChar_t *GetPixelData(Int_t iList);
    void GetFadcNoise(UChar_t asF[]);

    TClonesArray *&GetPixelList()
    {
	//
	//   returns a Pointer to the pixel list
	//
	return Pixels;
    }

    ULong_t GetTimeStamp()
    {
	return fTimeStamp;
    }

    ClassDef(MRawEvt, 1)
};				// end of class definition of MRawEvt

#endif
