#ifndef MOBJBUFFER_H
#define MOBJBUFFER_H

#include "Magic.h"

#include <TTree.h>
#include <TBranch.h>

#include <TNamed.h>
#include <TObjArray.h>

#include "MParContainer.h"

class MFile;
class MFileDescrIn;
class MFileDescrOut;

//class MRuntimeDb;

class MObjBuffer : public MParContainer
{
private:
    TObjArray objs;

    Int_t nPreObjs;       // number of object in the future
    Int_t nObjPos;        // pos of present object
    Int_t nPostObjs;      // number of objects in the past
    Int_t nEntries;       // number of entries in ring buffer

    Bool_t fIsInput;      // flag: is this an input container?
    Bool_t fIsOutput;     // flag: is this an output container?

    Bool_t fHasChanged;   // flag: the data of the 'present'-object has changed

    MFileDescrIn  *pFileIn;   //! Input File
    MFileDescrOut *pFileOut;  //! Input File

    Int_t nPos;           // in Tree

public:
    MObjBuffer(MParContainer *o, Int_t nevts=1,
               const char *name=NULL, const char *title=NULL);

    Bool_t IsBuffer()                { return kTRUE; }

    Bool_t IsInput()                 { return fIsInput; }
    Bool_t IsOutput()                { return fIsOutput; }

    Bool_t HasChanged()              { return fHasChanged; }

    void SetAsInput(MFile *f, Bool_t i=kTRUE);
    void SetAsOutput(MFile *f, Bool_t o=kTRUE);

    void SetChanged(Bool_t c=kTRUE)  { fHasChanged = c; }

    MParContainer *operator() ()
    {
	return (MParContainer*)objs[(nObjPos+nEntries)%nEntries];
    }

    MParContainer *GetEntry(Int_t i)
    {
	return (MParContainer*)objs[(nEntries+nObjPos+i)%nEntries];
    }

    Int_t GetNextEvent(Int_t time);
    void PutEvent();

    void Fill();

    Int_t GetEventNr()
    {
        return nPos;
    }

    ClassDef(MObjBuffer, 1)	// buffer for n complete events
};

#endif
